/**
 * 项目：互联网医疗
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.base;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serial;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown = true)
public abstract class BaseParam<E> implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 将查询参数转化为查询Wrapper
     * @param columnPrefix
     * @return queryWrapper
     */
    public abstract QueryWrapper<E> toQueryWrapper(String columnPrefix);

    /**
     * 将查询参数转化为查询Wrapper
     * @return queryWrapper
     */
    public abstract QueryWrapper<E> toQueryWrapper();
}
