/**
 * 项目：互联网医疗
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.config;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.time.Clock;

@Configuration
public class OpenApiConfig {

    @Bean
    public Clock clock() {
        return Clock.systemUTC();
    }

    @Bean
    public OpenAPI customOpenAPI(
            @Value("${app.api-version}") String apiVersion,
            @Value("${app.project-url}") String projectUrl) {

        return new OpenAPI()
                .info(
                        new Info()
                                .title("互联网医疗接口")
                                .description("请根据实际需要酌情使用.")
                                .version(apiVersion)
                                .license(new License().name("Apache 2.0")))
                .externalDocs(new ExternalDocumentation().description("Project Url").url(projectUrl));
    }
}
