/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：权限表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.enums.AuthorityTypeEnum;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`sys_authority`")
@Schema(name = "Authority", description = "权限表")
public class Authority extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * Id
     */
    @Schema(description = "Id")
    @TableField(exist = false)
    private List<Authority> children;
    /**
     * 父级Id
     */
    @TableField(value = "authority_id")
    @Schema(description = "父级Id", nullable = false)
    private Long authorityId;
    /**
     * 权限类型
     */
    @TableField(value = "type")
    @Schema(description = "权限类型", nullable = false)
    private AuthorityTypeEnum type;
    /**
     * 名称
     */
    @TableField(value = "name")
    @Schema(description = "名称", nullable = false)
    private String name;
    /**
     * 路径
     */
    @TableField(value = "path")
    @Schema(description = "路径")
    private String path;
    /**
     * 重定向路径
     */
    @TableField(value = "redirect")
    @Schema(description = "重定向路径")
    private String redirect;
    /**
     * 内嵌Url
     */
    @TableField(value = "frame_src")
    @Schema(description = "内嵌Url")
    private String frameSrc;
    /**
     * 是否缓存
     */
    @TableField(value = "keep_alive")
    @Schema(description = "是否缓存", nullable = false)
    private Boolean keepAlive;
    /**
     * 是否隐藏
     */
    @TableField(value = "hidden")
    @Schema(description = "是否隐藏", nullable = false)
    private Boolean hidden;
    /**
     * 页面组件
     */
    @TableField(value = "component")
    @Schema(description = "页面组件")
    private String component;
    /**
     * 标题
     */
    @TableField(value = "title")
    @Schema(description = "标题", nullable = false)
    private String title;
    /**
     * 图标
     */
    @TableField(value = "icon")
    @Schema(description = "图标")
    private String icon;
    /**
     * 序号
     */
    @TableField(value = "sort_order")
    @Schema(description = "序号", nullable = false)
    private Long sortOrder;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "", nullable = false)
    private java.util.Date createTime;
    /**
     * 
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "", nullable = false)
    private java.util.Date updateTime;

    /**
     * 设置默认值
     */
    @Override
    public Authority setDefault() {
        if (this.getAuthorityId() == null) {
            this.setAuthorityId(0L);
        }
        if (this.getType() == null) {
            this.setType(AuthorityTypeEnum.MENU);
        }
        if (this.getKeepAlive() == null) {
            this.setKeepAlive(null);
        }
        if (this.getHidden() == null) {
            this.setHidden(null);
        }
        if (this.getSortOrder() == null) {
            this.setSortOrder(0L);
        }
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getAuthorityId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "父级Id不能为空！");
            }
            return false;
        }
        if (this.getType() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "权限类型不能为空！");
            }
            return false;
        }
        if (this.getName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "名称不能为空！");
            }
            return false;
        }
        if (this.getKeepAlive() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "是否缓存不能为空！");
            }
            return false;
        }
        if (this.getHidden() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "是否隐藏不能为空！");
            }
            return false;
        }
        if (this.getTitle() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "标题不能为空！");
            }
            return false;
        }
        if (this.getSortOrder() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "序号不能为空！");
            }
            return false;
        }
        Long sortOrderMax = Long.valueOf("99999");
        if (this.getSortOrder() >= sortOrderMax) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "序号不能大于或等于99999！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
