/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：优惠券信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.enums.CouponTypeEnum;
import com.xwd.hospital.server.enums.YesNoEnum;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`pms_coupon_info`")
@Schema(name = "CouponInfo", description = "优惠券信息表")
public class CouponInfo extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 优惠券名称
     */
    @TableField(value = "coupon_name")
    @Schema(description = "优惠券名称", nullable = false)
    private Long couponName;
    /**
     * 优惠券类型
     */
    @TableField(value = "coupon_type")
    @Schema(description = "优惠券类型", nullable = false)
    private CouponTypeEnum couponType;
    /**
     * 优惠金额/折扣
     */
    @TableField(value = "coupon_discount")
    @Schema(description = "优惠金额/折扣", nullable = false)
    private java.math.BigDecimal couponDiscount;
    /**
     * 优惠券开始时间
     */
    @TableField(value = "coupon_start_date")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "优惠券开始时间", nullable = false)
    private java.util.Date couponStartDate;
    /**
     * 优惠券结束时间
     */
    @TableField(value = "coupon_end_date")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "优惠券结束时间", nullable = false)
    private java.util.Date couponEndDate;
    /**
     * 是否删除
     */
    @TableField(value = "delete_status")
    @Schema(description = "是否删除", nullable = false)
    private YesNoEnum deleteStatus;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "创建时间", nullable = false)
    private java.util.Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "更新时间", nullable = false)
    private java.util.Date updateTime;

    /**
     * 设置默认值
     */
    @Override
    public CouponInfo setDefault() {
        if (this.getCouponType() == null) {
            this.setCouponType(CouponTypeEnum.FULL_DISCOUNT);
        }
        if (this.getDeleteStatus() == null) {
            this.setDeleteStatus(YesNoEnum.NO);
        }
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getCouponName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "优惠券名称不能为空！");
            }
            return false;
        }
        if (this.getCouponType() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "优惠券类型不能为空！");
            }
            return false;
        }
        if (this.getCouponDiscount() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "优惠金额/折扣不能为空！");
            }
            return false;
        }
        if (this.getCouponStartDate() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "优惠券开始时间不能为空！");
            }
            return false;
        }
        if (this.getCouponEndDate() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "优惠券结束时间不能为空！");
            }
            return false;
        }
        if (this.getDeleteStatus() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "是否删除不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
