/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：医生信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.enums.DoctorStateEnum;
import com.xwd.hospital.server.enums.SexTypeEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.domain.MedicalQualifications;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`pms_doctor_info`")
@Schema(name = "DoctorInfo", description = "医生信息表")
public class DoctorInfo extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 用户Id
     */
    @TableField(value = "user_id")
    @Schema(description = "用户Id", nullable = false)
    private Long userId;
    /**
     * 用户Id
     */
    @Schema(description = "用户Id")
    @TableField(exist = false)
    private User user;
    /**
     * 医生医疗资质Id
     */
    @TableField(value = "medical_qualification_id")
    @Schema(description = "医生医疗资质Id")
    private Long medicalQualificationId;
    /**
     * 医生医疗资质Id
     */
    @Schema(description = "医生医疗资质Id")
    @TableField(exist = false)
    private MedicalQualifications medicalQualification;
    /**
     * 医生状态
     */
    @TableField(value = "doctor_state")
    @Schema(description = "医生状态", nullable = false)
    private DoctorStateEnum doctorState;
    /**
     * 医生姓名
     */
    @TableField(value = "doctor_name")
    @Schema(description = "医生姓名", nullable = false)
    private String doctorName;
    /**
     * 性别
     */
    @TableField(value = "sex")
    @Schema(description = "性别", nullable = false)
    private SexTypeEnum sex;
    /**
     * 身份证号码
     */
    @TableField(value = "id_no")
    @Schema(description = "身份证号码", nullable = false)
    private String idNo;
    /**
     * 出生日期
     */
    @TableField(value = "born_date")
    @Schema(description = "出生日期", nullable = false)
    private String bornDate;
    /**
     * 手机号码
     */
    @TableField(value = "phone_number")
    @Schema(description = "手机号码")
    private String phoneNumber;
    /**
     * 擅长领域
     */
    @TableField(value = "expertise_area")
    @Schema(description = "擅长领域")
    private String expertiseArea;
    /**
     * 简介
     */
    @TableField(value = "introduction", select = false)
    @Schema(description = "简介")
    private String introduction;
    /**
     * 身份证图片正面
     */
    @TableField(value = "id_card_picture_front")
    @Schema(description = "身份证图片正面")
    private String idCardPictureFront;
    /**
     * 身份证图片背面
     */
    @TableField(value = "id_card_picture_back")
    @Schema(description = "身份证图片背面")
    private String idCardPictureBack;
    /**
     * 是否删除
     */
    @TableField(value = "delete_status")
    @Schema(description = "是否删除", nullable = false)
    private YesNoEnum deleteStatus;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "创建时间", nullable = false)
    private java.util.Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "更新时间", nullable = false)
    private java.util.Date updateTime;

    private List<DoctorServiceInfo> serviceInfoList;

    /**
     * 设置默认值
     */
    @Override
    public DoctorInfo setDefault() {
        if (this.getDoctorState() == null) {
            this.setDoctorState(DoctorStateEnum.NORMAL);
        }
        if (this.getSex() == null) {
            this.setSex(SexTypeEnum.MALE);
        }
        if (this.getDeleteStatus() == null) {
            this.setDeleteStatus(YesNoEnum.NO);
        }
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getUserId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "用户Id不能为空！");
            }
            return false;
        }
        if (this.getDoctorState() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "医生状态不能为空！");
            }
            return false;
        }
        if (this.getDoctorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "医生姓名不能为空！");
            }
            return false;
        }
        if (this.getSex() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "性别不能为空！");
            }
            return false;
        }
        if (this.getIdNo() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "身份证号码不能为空！");
            }
            return false;
        }
        if (this.getBornDate() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "出生日期不能为空！");
            }
            return false;
        }
        if (this.getDeleteStatus() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "是否删除不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
