/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：影像报告表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.enums.SexTypeEnum;
import com.xwd.hospital.server.enums.ReportStateEnum;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`pms_medical_report`")
@Schema(name = "MedicalReport", description = "影像报告表")
public class MedicalReport extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 患者姓名
     */
    @TableField(value = "patient_name")
    @Schema(description = "患者姓名", nullable = false)
    private Long patientName;
    /**
     * 患者身份证号码
     */
    @TableField(value = "patient_id_no")
    @Schema(description = "患者身份证号码", nullable = false)
    private String patientIdNo;
    /**
     * 性别
     */
    @TableField(value = "sex")
    @Schema(description = "性别", nullable = false)
    private SexTypeEnum sex;
    /**
     * 患者年龄
     */
    @TableField(value = "age")
    @Schema(description = "患者年龄", nullable = false)
    private Integer age;
    /**
     * 影像报告项目
     */
    @TableField(value = "report_item", select = false)
    @Schema(description = "影像报告项目", nullable = false)
    private String reportItem;
    /**
     * 影像说明
     */
    @TableField(value = "report_declare", select = false)
    @Schema(description = "影像说明", nullable = false)
    private String reportDeclare;
    /**
     * 报告医院
     */
    @TableField(value = "report_hospital")
    @Schema(description = "报告医院", nullable = false)
    private String reportHospital;
    /**
     * 报告医生
     */
    @TableField(value = "report_doctor")
    @Schema(description = "报告医生", nullable = false)
    private String reportDoctor;
    /**
     * 报告时间
     */
    @TableField(value = "report_time")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "报告时间", nullable = false)
    private java.util.Date reportTime;
    /**
     * 影像报告状态
     */
    @TableField(value = "report_state")
    @Schema(description = "影像报告状态", nullable = false)
    private ReportStateEnum reportState;
    /**
     * 医生医嘱
     */
    @TableField(value = "doctor_asks", select = false)
    @Schema(description = "医生医嘱")
    private String doctorAsks;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "创建时间", nullable = false)
    private java.util.Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "更新时间", nullable = false)
    private java.util.Date updateTime;

    /**
     * 设置默认值
     */
    @Override
    public MedicalReport setDefault() {
        if (this.getSex() == null) {
            this.setSex(SexTypeEnum.MALE);
        }
        if (this.getReportState() == null) {
            this.setReportState(ReportStateEnum.TO_INTERPRET);
        }
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getPatientName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "患者姓名不能为空！");
            }
            return false;
        }
        if (this.getPatientIdNo() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "患者身份证号码不能为空！");
            }
            return false;
        }
        if (this.getSex() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "性别不能为空！");
            }
            return false;
        }
        if (this.getAge() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "患者年龄不能为空！");
            }
            return false;
        }
        if (this.getReportItem() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "影像报告项目不能为空！");
            }
            return false;
        }
        if (this.getReportDeclare() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "影像说明不能为空！");
            }
            return false;
        }
        if (this.getReportHospital() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "报告医院不能为空！");
            }
            return false;
        }
        if (this.getReportDoctor() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "报告医生不能为空！");
            }
            return false;
        }
        if (this.getReportTime() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "报告时间不能为空！");
            }
            return false;
        }
        if (this.getReportState() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "影像报告状态不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
