/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：订单支付表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.enums.PayStateEnum;
import com.xwd.hospital.server.enums.PayPathEnum;
import com.xwd.hospital.server.domain.Order;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`pms_order_pay`")
@Schema(name = "OrderPay", description = "订单支付表")
public class OrderPay extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 订单id
     */
    @TableField(value = "order_id")
    @Schema(description = "订单id", nullable = false)
    private Long orderId;
    /**
     * 订单id
     */
    @Schema(description = "订单id")
    @TableField(exist = false)
    private Order order;
    /**
     * 订单号
     */
    @TableField(value = "order_no")
    @Schema(description = "订单号", nullable = false)
    private String orderNo;
    /**
     * 支付流水号
     */
    @TableField(value = "pay_no")
    @Schema(description = "支付流水号", nullable = false)
    private String payNo;
    /**
     * 支付状态
     */
    @TableField(value = "pay_state")
    @Schema(description = "支付状态", nullable = false)
    private PayStateEnum payState;
    /**
     * 支付方式类型
     */
    @TableField(value = "pay_path")
    @Schema(description = "支付方式类型", nullable = false)
    private PayPathEnum payPath;
    /**
     * 支付金额
     */
    @TableField(value = "pay_money")
    @Schema(description = "支付金额", nullable = false)
    private java.math.BigDecimal payMoney;
    /**
     * 支付时间
     */
    @TableField(value = "pay_time")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "支付时间")
    private java.util.Date payTime;
    /**
     * 完成时间
     */
    @TableField(value = "complete_time")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "完成时间")
    private java.util.Date completeTime;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "创建时间", nullable = false)
    private java.util.Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "更新时间", nullable = false)
    private java.util.Date updateTime;

    /**
     * 设置默认值
     */
    @Override
    public OrderPay setDefault() {
        if (this.getPayState() == null) {
            this.setPayState(PayStateEnum.TO_PAY);
        }
        if (this.getPayPath() == null) {
            this.setPayPath(PayPathEnum.WX_PAY);
        }
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getOrderId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "订单id不能为空！");
            }
            return false;
        }
        if (this.getOrderNo() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "订单号不能为空！");
            }
            return false;
        }
        if (this.getPayNo() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "支付流水号不能为空！");
            }
            return false;
        }
        if (this.getPayState() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "支付状态不能为空！");
            }
            return false;
        }
        if (this.getPayPath() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "支付方式类型不能为空！");
            }
            return false;
        }
        if (this.getPayMoney() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "支付金额不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
