/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：订单退款表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.enums.RefundStateEnum;
import com.xwd.hospital.server.domain.Order;
import com.xwd.hospital.server.domain.OrderPay;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`pms_order_refund`")
@Schema(name = "OrderRefund", description = "订单退款表")
public class OrderRefund extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 订单id
     */
    @TableField(value = "order_id")
    @Schema(description = "订单id", nullable = false)
    private Long orderId;
    /**
     * 订单id
     */
    @Schema(description = "订单id")
    @TableField(exist = false)
    private Order order;
    /**
     * 订单号
     */
    @TableField(value = "order_no")
    @Schema(description = "订单号", nullable = false)
    private String orderNo;
    /**
     * 订单支付id
     */
    @TableField(value = "order_pay_id")
    @Schema(description = "订单支付id", nullable = false)
    private Long orderPayId;
    /**
     * 订单支付id
     */
    @Schema(description = "订单支付id")
    @TableField(exist = false)
    private OrderPay orderPay;
    /**
     * 退款流水号
     */
    @TableField(value = "refund_no")
    @Schema(description = "退款流水号", nullable = false)
    private String refundNo;
    /**
     * 退款状态
     */
    @TableField(value = "refund_state")
    @Schema(description = "退款状态", nullable = false)
    private RefundStateEnum refundState;
    /**
     * 退款金额
     */
    @TableField(value = "refund_money")
    @Schema(description = "退款金额", nullable = false)
    private java.math.BigDecimal refundMoney;
    /**
     * 退款时间
     */
    @TableField(value = "refund_time")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "退款时间")
    private java.util.Date refundTime;
    /**
     * 完成时间
     */
    @TableField(value = "complete_time")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "完成时间")
    private java.util.Date completeTime;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "创建时间", nullable = false)
    private java.util.Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "更新时间", nullable = false)
    private java.util.Date updateTime;

    /**
     * 设置默认值
     */
    @Override
    public OrderRefund setDefault() {
        if (this.getRefundState() == null) {
            this.setRefundState(RefundStateEnum.REFUNDING);
        }
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getOrderId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "订单id不能为空！");
            }
            return false;
        }
        if (this.getOrderNo() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "订单号不能为空！");
            }
            return false;
        }
        if (this.getOrderPayId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "订单支付id不能为空！");
            }
            return false;
        }
        if (this.getRefundNo() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "退款流水号不能为空！");
            }
            return false;
        }
        if (this.getRefundState() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "退款状态不能为空！");
            }
            return false;
        }
        if (this.getRefundMoney() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "退款金额不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
