/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：就诊人信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.enums.PatientRelationEnum;
import com.xwd.hospital.server.enums.SexTypeEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.UserInfo;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`pms_patient_info`")
@Schema(name = "PatientInfo", description = "就诊人信息表")
public class PatientInfo extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 用户Id
     */
    @TableField(value = "user_info_id")
    @Schema(description = "用户Id", nullable = false)
    private Long userInfoId;
    /**
     * 用户Id
     */
    @Schema(description = "用户Id")
    @TableField(exist = false)
    private UserInfo userInfo;
    /**
     * 就诊人关系
     */
    @TableField(value = "relation")
    @Schema(description = "就诊人关系", nullable = false)
    private PatientRelationEnum relation;
    /**
     * 就诊人姓名
     */
    @TableField(value = "patient_name")
    @Schema(description = "就诊人姓名", nullable = false)
    private String patientName;
    /**
     * 性别
     */
    @TableField(value = "sex")
    @Schema(description = "性别", nullable = false)
    private SexTypeEnum sex;
    /**
     * 身份证号码
     */
    @TableField(value = "id_no")
    @Schema(description = "身份证号码", nullable = false)
    private String idNo;
    /**
     * 手机号码
     */
    @TableField(value = "phone_number")
    @Schema(description = "手机号码")
    private String phoneNumber;
    /**
     * 出生日期
     */
    @TableField(value = "born_date")
    @Schema(description = "出生日期", nullable = false)
    private String bornDate;
    /**
     * 是否有监护人
     */
    @TableField(value = "guardian_state")
    @Schema(description = "是否有监护人", nullable = false)
    private YesNoEnum guardianState;
    /**
     * 就诊人姓名
     */
    @TableField(value = "guardian_name")
    @Schema(description = "就诊人姓名")
    private String guardianName;
    /**
     * 监护人身份证号码
     */
    @TableField(value = "guardian_identification_number")
    @Schema(description = "监护人身份证号码")
    private String guardianIdentificationNumber;
    /**
     * 监护人手机号码
     */
    @TableField(value = "guardian_phone_number")
    @Schema(description = "监护人手机号码")
    private String guardianPhoneNumber;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "创建时间", nullable = false)
    private java.util.Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "更新时间", nullable = false)
    private java.util.Date updateTime;

    /**
     * 设置默认值
     */
    @Override
    public PatientInfo setDefault() {
        if (this.getRelation() == null) {
            this.setRelation(PatientRelationEnum.SELF);
        }
        if (this.getSex() == null) {
            this.setSex(SexTypeEnum.MALE);
        }
        if (this.getGuardianState() == null) {
            this.setGuardianState(YesNoEnum.NO);
        }
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getUserInfoId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "用户Id不能为空！");
            }
            return false;
        }
        if (this.getRelation() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "就诊人关系不能为空！");
            }
            return false;
        }
        if (this.getPatientName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "就诊人姓名不能为空！");
            }
            return false;
        }
        if (this.getSex() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "性别不能为空！");
            }
            return false;
        }
        if (this.getIdNo() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "身份证号码不能为空！");
            }
            return false;
        }
        if (this.getBornDate() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "出生日期不能为空！");
            }
            return false;
        }
        if (this.getGuardianState() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "是否有监护人不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
