/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：就诊人处方信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.PatientInfo;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`pms_patient_prescription_info`")
@Schema(name = "PatientPrescriptionInfo", description = "就诊人处方信息表")
public class PatientPrescriptionInfo extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 就诊人Id
     */
    @TableField(value = "patient_id")
    @Schema(description = "就诊人Id", nullable = false)
    private Long patientId;
    /**
     * 就诊人Id
     */
    @Schema(description = "就诊人Id")
    @TableField(exist = false)
    private PatientInfo patient;
    /**
     * 医院名称
     */
    @TableField(value = "hospital_name")
    @Schema(description = "医院名称", nullable = false)
    private String hospitalName;
    /**
     * 科室名称
     */
    @TableField(value = "department_name")
    @Schema(description = "科室名称", nullable = false)
    private String departmentName;
    /**
     * 处方时间
     */
    @TableField(value = "prescription_time")
    @Schema(description = "处方时间", nullable = false)
    private String prescriptionTime;
    /**
     * 处方说明
     */
    @TableField(value = "prescription_introduce", select = false)
    @Schema(description = "处方说明", nullable = false)
    private String prescriptionIntroduce;
    /**
     * 是否删除
     */
    @TableField(value = "delete_status")
    @Schema(description = "是否删除", nullable = false)
    private YesNoEnum deleteStatus;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "创建时间", nullable = false)
    private java.util.Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "更新时间", nullable = false)
    private java.util.Date updateTime;

    /**
     * 设置默认值
     */
    @Override
    public PatientPrescriptionInfo setDefault() {
        if (this.getDeleteStatus() == null) {
            this.setDeleteStatus(YesNoEnum.NO);
        }
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getPatientId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "就诊人Id不能为空！");
            }
            return false;
        }
        if (this.getHospitalName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "医院名称不能为空！");
            }
            return false;
        }
        if (this.getDepartmentName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "科室名称不能为空！");
            }
            return false;
        }
        if (this.getPrescriptionTime() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "处方时间不能为空！");
            }
            return false;
        }
        if (this.getPrescriptionIntroduce() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "处方说明不能为空！");
            }
            return false;
        }
        if (this.getDeleteStatus() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "是否删除不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
