/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：角色权限对应表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`sys_role_authority`")
@Schema(name = "RoleAuthority", description = "角色权限对应表")
public class RoleAuthority extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * sys_role.id
     */
    @TableField(value = "role_id")
    @Schema(description = "sys_role.id", nullable = false)
    private Long roleId;
    /**
     * sys_authority.id
     */
    @TableField(value = "authority_id")
    @Schema(description = "sys_authority.id", nullable = false)
    private Long authorityId;

    /**
     * 设置默认值
     */
    @Override
    public RoleAuthority setDefault() {
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getRoleId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "sys_role.id不能为空！");
            }
            return false;
        }
        if (this.getAuthorityId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "sys_authority.id不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
