/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：用户地址关系表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.domain.UserInfo;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`pms_user_address_info`")
@Schema(name = "UserAddressInfo", description = "用户地址关系表")
public class UserAddressInfo extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 用户Id
     */
    @TableField(value = "user_info_id")
    @Schema(description = "用户Id", nullable = false)
    private Long userInfoId;
    /**
     * 用户Id
     */
    @Schema(description = "用户Id")
    @TableField(exist = false)
    private UserInfo userInfo;
    /**
     * 姓名
     */
    @TableField(value = "name")
    @Schema(description = "姓名", nullable = false)
    private String name;
    /**
     * 手机号码
     */
    @TableField(value = "phone_number")
    @Schema(description = "手机号码", nullable = false)
    private String phoneNumber;
    /**
     * 省
     */
    @TableField(value = "province")
    @Schema(description = "省", nullable = false)
    private String province;
    /**
     * 市
     */
    @TableField(value = "city")
    @Schema(description = "市", nullable = false)
    private String city;
    /**
     * 区
     */
    @TableField(value = "district")
    @Schema(description = "区", nullable = false)
    private String district;
    /**
     * 详细地址
     */
    @TableField(value = "detail_address")
    @Schema(description = "详细地址", nullable = false)
    private String detailAddress;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "创建时间", nullable = false)
    private java.util.Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "更新时间", nullable = false)
    private java.util.Date updateTime;

    /**
     * 设置默认值
     */
    @Override
    public UserAddressInfo setDefault() {
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getUserInfoId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "用户Id不能为空！");
            }
            return false;
        }
        if (this.getName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "姓名不能为空！");
            }
            return false;
        }
        if (this.getPhoneNumber() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "手机号码不能为空！");
            }
            return false;
        }
        if (this.getProvince() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "省不能为空！");
            }
            return false;
        }
        if (this.getCity() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "市不能为空！");
            }
            return false;
        }
        if (this.getDistrict() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "区不能为空！");
            }
            return false;
        }
        if (this.getDetailAddress() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "详细地址不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
