/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：电话咨询订单记录信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.repository.base;

import java.io.Serializable;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.springframework.stereotype.Repository;
import org.apache.ibatis.annotations.Param;
import com.xwd.hospital.server.domain.PhoneOrderRecord;

@Repository
public interface PhoneOrderRecordBaseMapper extends BaseMapper<PhoneOrderRecord> {
    /**
     * 根据 ID 更新所有字段
     *
     * @param entity 实体对象
     */
    int updateAllFieldsById(@Param(Constants.ENTITY) PhoneOrderRecord entity);

    /**
     * 批量插入
     *
     * @param records 实体对象列表
     */
    int batchInsert(@Param("records") List<PhoneOrderRecord> records);
}
