/**
 * 项目：互联网医疗
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.resolver;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.convert.NumberWithFormat;
import com.xwd.hospital.server.annotation.AuthUser;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.service.UserService;
import com.xwd.hospital.server.util.SpringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class AuthUserResolver implements HandlerMethodArgumentResolver {

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(AuthUser.class);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        if (!StpUtil.isLogin()) {
            return null;
        }
        AuthUser au = parameter.getParameterAnnotation(AuthUser.class);
        String username = StpUtil.getLoginIdAsString();
        User user;
        if (au.queryDb()) {
            UserService userService = SpringUtils.getBean(UserService.class);
            user = userService.selectByUsername(username);
        } else {
            user = new User();
            user.setUsername(username);
            Object userId = StpUtil.getExtra("userId");
            if (userId instanceof NumberWithFormat userIdValue) {
                user.setId(userIdValue.longValue());
            }
            System.out.println("userId=" + StpUtil.getExtra("userId"));
        }
        return user;
    }
}
