/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：医生信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest;

import java.util.List;
import java.util.Arrays;

import cn.dev33.satoken.stp.SaLoginModel;
import cn.dev33.satoken.stp.StpUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.xwd.hospital.server.annotation.ApiCommon;
import com.xwd.hospital.server.annotation.AuthUser;
import com.xwd.hospital.server.base.BaseController;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.dto.DoctorDto;
import com.xwd.hospital.server.dto.OrderDto;
import com.xwd.hospital.server.rest.req.DoctorSearchParam;
import com.xwd.hospital.server.rest.res.ApiCode;
import com.xwd.hospital.server.domain.DoctorInfo;
import com.xwd.hospital.server.rest.req.DoctorInfoParam;
import com.xwd.hospital.server.rest.res.ApiResponse;
import com.xwd.hospital.server.service.DoctorInfoService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@Tag(name = "DoctorInfoController", description = "医生信息表管理")
@RequestMapping("/v1/pms/doctor-info")
public class DoctorInfoController extends BaseController<DoctorInfoService, DoctorInfo, DoctorInfoParam> {

    @Resource
    public void setService(DoctorInfoService service) {
        this.service = service;
    }

    /**
     * 新增
     *
     * @param entity 要新增的对象
     * @return 新增的对象
     */
    @PostMapping("/")
    @Operation(summary = "新增")
    @Override
    public ApiResponse<DoctorInfo> add(@RequestBody DoctorInfo entity, @AuthUser User user) {
        entity.setEditorId(user.getId());
        entity.setEditorName(user.getUsername());
        entity.setDefault().validate(true);
        this.service.save(entity);
        return ApiResponse.ok(this.service.getById(entity.getId()));
    }

    /**
     * 批量新增
     *
     * @param entityList 要新增的对象
     * @return boolean 成功或失败
     */
    @PostMapping("/batch-save")
    @Operation(summary = "批量新增")
    @Override
    public ApiResponse<Boolean> batchSave(@RequestBody List<DoctorInfo> entityList, @AuthUser User user) {
        entityList.forEach(entity -> {
            entity.setEditorId(user.getId());
            entity.setEditorName(user.getUsername());
            entity.setDefault().validate(true);
        });
        return ApiResponse.ok(this.service.saveBatch(entityList));
    }

    /**
     * 小程序医生列表
     *
     */
    @PostMapping("/queryDoctorList")
    @Operation(summary = "小程序医生列表")
    public ApiResponse queryDoctorList(@RequestBody DoctorSearchParam param,
                                       @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                       @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {
        Page<DoctorDto> page = new Page<>(pageNum, pageSize);
        List<DoctorDto> list = this.service.queryDoctorList(param);
        page.setRecords(list);

        return ApiResponse.ok(page);
    }


}
