package com.xwd.hospital.server.rest;

import cn.dev33.satoken.stp.SaLoginModel;
import cn.dev33.satoken.stp.StpUtil;
import com.xwd.hospital.server.annotation.ApiCommon;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.dto.LoginDto;
import com.xwd.hospital.server.dto.PatientMiniAppHomeDto;
import com.xwd.hospital.server.rest.res.ApiResponse;
import com.xwd.hospital.server.service.HomeService;
import com.xwd.hospital.server.service.RedisService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.web.bind.annotation.*;
import redis.clients.jedis.JedisPool;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Slf4j
@RestController
@Tag(name = "HomeController", description = "首页信息")
@RequestMapping("/v1/system/home")
public class HomeController {
    @Resource
    private HomeService homeService;
    @Resource
    private RedisService redisService;

    /**
     * <pre>
     * 患者端首页
     * </pre>
     */
    @Operation(summary = "患者端首页")
    @PostMapping("/patientMiniAppHome")
    @ApiCommon
    public ApiResponse<PatientMiniAppHomeDto> patientMiniAppHome() {

        return ApiResponse.ok(homeService.patientMiniAppHome());
    }

    /**
     * <pre>
     * 医生端首页
     * </pre>
     */
    @Operation(summary = "医生端首页")
    @PostMapping("/doctorMiniAppHome")
    @ApiCommon
    public ApiResponse doctorMiniAppHome(@RequestParam("doctorId") Long doctorId) {

        return ApiResponse.ok(homeService.doctorMiniAppHome(doctorId));
    }

    /**
     * <pre>
     * test
     * </pre>
     */
    @Operation(summary = "test")
    @PostMapping("/test")
    @ApiCommon
    public ApiResponse test() {
        JedisPool jedis = new JedisPool(new GenericObjectPoolConfig(), "localhost", 6379, 2000, "123456");
        jedis.getResource().get("zhuweidong");
//        redisService.setExpire("zhuweidong","123456",30, TimeUnit.SECONDS);
        return ApiResponse.ok(jedis.getResource().get("zhuweidong"));
    }
}
