/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：订单退款表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest;

import java.util.List;
import java.util.Arrays;

import cn.dev33.satoken.stp.SaLoginModel;
import cn.dev33.satoken.stp.StpUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.xwd.hospital.server.annotation.ApiCommon;
import com.xwd.hospital.server.annotation.AuthUser;
import com.xwd.hospital.server.base.BaseController;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.rest.res.ApiCode;
import com.xwd.hospital.server.domain.OrderRefund;
import com.xwd.hospital.server.rest.req.OrderRefundParam;
import com.xwd.hospital.server.rest.res.ApiResponse;
import com.xwd.hospital.server.service.OrderRefundService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@Tag(name = "OrderRefundController", description = "订单退款表管理")
@RequestMapping("/v1/pms/order-refund")
public class OrderRefundController extends BaseController<OrderRefundService, OrderRefund, OrderRefundParam> {

    @Resource
    public void setService(OrderRefundService service) {
        this.service = service;
    }

    /**
     * 新增
     *
     * @param entity 要新增的对象
     * @return 新增的对象
     */
    @PostMapping("/")
    @Operation(summary = "新增")
    @Override
    public ApiResponse<OrderRefund> add(@RequestBody OrderRefund entity, @AuthUser User user) {
        entity.setEditorId(user.getId());
        entity.setEditorName(user.getUsername());
        entity.setDefault().validate(true);
        this.service.save(entity);
        return ApiResponse.ok(this.service.getById(entity.getId()));
    }

    /**
     * 批量新增
     *
     * @param entityList 要新增的对象
     * @return boolean 成功或失败
     */
    @PostMapping("/batch-save")
    @Operation(summary = "批量新增")
    @Override
    public ApiResponse<Boolean> batchSave(@RequestBody List<OrderRefund> entityList, @AuthUser User user) {
        entityList.forEach(entity -> {
            entity.setEditorId(user.getId());
            entity.setEditorName(user.getUsername());
            entity.setDefault().validate(true);
        });
        return ApiResponse.ok(this.service.saveBatch(entityList));
    }


}
