package com.xwd.hospital.server.rest;

import com.xwd.hospital.server.annotation.ApiCommon;
import com.xwd.hospital.server.enums.PayPathEnum;
import com.xwd.hospital.server.rest.res.ApiResponse;
import com.xwd.hospital.server.service.PaymentService;
import com.xwd.hospital.server.service.SmsService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@Tag(name = "PaymentController", description = "支付相关服务")
@RequestMapping("/v1/system/payment")
public class PaymentController {
    @Resource
    private PaymentService paymentService;

    /**
     * <pre>
     * 支付行为调起
     * </pre>
     */
    @Operation(summary = "支付行为调起")
    @PostMapping("/startPay")
    @ApiCommon
    public ApiResponse startPay(@RequestParam("orderNo") String orderNo,@RequestParam("payPath")  PayPathEnum payPath) {

        return ApiResponse.ok(paymentService.startPay(orderNo, payPath));
    }

    /**
     * <pre>
     * 支付回调接口
     * </pre>
     */
    @Operation(summary = "支付回调接口")
    @PostMapping("/payNotify")
    @ApiCommon
    public void payNotify(HttpServletRequest request, HttpServletResponse response) {
        paymentService.payNotify(request,response);
    }

    /**
     * <pre>
     * 退款回调接口
     * </pre>
     */
    @Operation(summary = "退款回调接口")
    @PostMapping("/refundNotify")
    @ApiCommon
    public void refundNotify(HttpServletRequest request, HttpServletResponse response) {
        paymentService.refundNotify(request,response);
    }

    /**
     * <pre>
     * 支付退款接口
     * </pre>
     */
    @Operation(summary = "支付退款接口")
    @PostMapping("/refundPay")
    @ApiCommon
    public ApiResponse refundPay(String orderNo) {
        paymentService.refundPay(orderNo);
        return ApiResponse.ok(true);
    }
}
