/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：角色权限对应表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest;

import java.util.List;
import java.util.Arrays;

import cn.dev33.satoken.stp.SaLoginModel;
import cn.dev33.satoken.stp.StpUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.xwd.hospital.server.annotation.ApiCommon;
import com.xwd.hospital.server.annotation.AuthUser;
import com.xwd.hospital.server.base.BaseController;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.rest.res.ApiCode;
import com.xwd.hospital.server.domain.RoleAuthority;
import com.xwd.hospital.server.rest.req.RoleAuthorityParam;
import com.xwd.hospital.server.rest.res.ApiResponse;
import com.xwd.hospital.server.service.RoleAuthorityService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@Tag(name = "RoleAuthorityController", description = "角色权限对应表管理")
@RequestMapping("/v1/system/role-authority")
public class RoleAuthorityController extends BaseController<RoleAuthorityService, RoleAuthority, RoleAuthorityParam> {

    @Resource
    public void setService(RoleAuthorityService service) {
        this.service = service;
    }




}
