package com.xwd.hospital.server.rest;

import com.xwd.hospital.server.annotation.ApiCommon;
import com.xwd.hospital.server.dto.PatientMiniAppHomeDto;
import com.xwd.hospital.server.rest.res.ApiResponse;
import com.xwd.hospital.server.service.SmsService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@Tag(name = "SmsController", description = "通信服务")
@RequestMapping("/v1/system/sms")
public class SmsController {
    @Resource
    private SmsService smsService;

    /**
     * <pre>
     * 发送短信验证码
     * </pre>
     */
    @Operation(summary = "发送短信验证码")
    @PostMapping("/sendSms")
    @ApiCommon
    public ApiResponse sendSms(@RequestParam("phone") String phone) {
        smsService.sendSms(phone);
        return ApiResponse.ok(smsService.sendSms(phone));
    }
}
