/**
 * 项目：互联网医疗
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest;

import com.xwd.hospital.server.annotation.ApiCommon;;
import com.xwd.hospital.server.annotation.AuthUsername;;
import com.xwd.hospital.server.rest.res.ApiResponse;
import com.xwd.hospital.server.util.FileUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

@Tag(name = "UploadController", description = "文件上传")
@Slf4j
@RestController
@RequestMapping("/v1/system/upload")
public class UploadController {

    @Value("${rest.upload-path}")
    private String uploadPath;

    @Operation(summary = "文件上传")
    @PostMapping
    @ApiCommon
    public ApiResponse upload(@RequestParam MultipartFile file, @AuthUsername String username) {
        String upload = FileUtils.upload(file, username, uploadPath);
        return ApiResponse.ok("/files/upload" + upload);
    }

}
