/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：权限表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.AuthorityTypeEnum;
import com.xwd.hospital.server.domain.Authority;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class AuthorityParam extends BaseParam<Authority> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 父级Id
     */
    @Parameter(description = "父级Id")
    private Long authorityId;
    /**
     * 权限类型
     */
    @Parameter(description = "权限类型")
    private AuthorityTypeEnum type;
    /**
     * 权限类型 IN值List
     */
    @Parameter(description = "权限类型 IN值List")
    private List<String> typeList;
    /**
     * 名称
     */
    @Parameter(description = "名称")
    private String name;
    /**
     * 路径
     */
    @Parameter(description = "路径")
    private String path;
    /**
     * 重定向路径
     */
    @Parameter(description = "重定向路径")
    private String redirect;
    /**
     * 内嵌Url
     */
    @Parameter(description = "内嵌Url")
    private String frameSrc;
    /**
     * 是否缓存
     */
    @Parameter(description = "是否缓存")
    private Boolean keepAlive;
    /**
     * 是否隐藏
     */
    @Parameter(description = "是否隐藏")
    private Boolean hidden;
    /**
     * 页面组件
     */
    @Parameter(description = "页面组件")
    private String component;
    /**
     * 标题
     */
    @Parameter(description = "标题")
    private String title;
    /**
     * 图标
     */
    @Parameter(description = "图标")
    private String icon;
    /**
     * 序号
     */
    @Parameter(description = "序号")
    private Long sortOrder;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "")
    private java.util.Date createTime;
    /**
     *  下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = " 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     *  上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = " 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "")
    private java.util.Date updateTime;
    /**
     *  下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = " 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     *  上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = " 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<Authority> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<Authority> toQueryWrapper(String columnPrefix) {
        QueryWrapper<Authority> wrapper = Wrappers.<Authority>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getAuthorityId() != null, columnPrefix + "authority_id", this.getAuthorityId());
        wrapper.eq(this.getType() != null, columnPrefix + "type", this.getType());
        wrapper.in(this.getTypeList() != null && this.getTypeList().size() > 0, columnPrefix + "type", this.getTypeList());
        if (this.getName() != null) {
            if (this.getName().startsWith("%") && this.getName().endsWith("%")) {
                wrapper.like(columnPrefix + "name", this.getName().substring(1, this.getName().length() - 1));
            } else if (this.getName().startsWith("%") && !this.getName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "name", this.getName().substring(1));
            } else if (this.getName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "name", this.getName().substring(0, this.getName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "name", this.getName());
            }
        }
        if (this.getPath() != null) {
            if (this.getPath().startsWith("%") && this.getPath().endsWith("%")) {
                wrapper.like(columnPrefix + "path", this.getPath().substring(1, this.getPath().length() - 1));
            } else if (this.getPath().startsWith("%") && !this.getPath().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "path", this.getPath().substring(1));
            } else if (this.getPath().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "path", this.getPath().substring(0, this.getPath().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "path", this.getPath());
            }
        }
        if (this.getRedirect() != null) {
            if (this.getRedirect().startsWith("%") && this.getRedirect().endsWith("%")) {
                wrapper.like(columnPrefix + "redirect", this.getRedirect().substring(1, this.getRedirect().length() - 1));
            } else if (this.getRedirect().startsWith("%") && !this.getRedirect().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "redirect", this.getRedirect().substring(1));
            } else if (this.getRedirect().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "redirect", this.getRedirect().substring(0, this.getRedirect().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "redirect", this.getRedirect());
            }
        }
        if (this.getFrameSrc() != null) {
            if (this.getFrameSrc().startsWith("%") && this.getFrameSrc().endsWith("%")) {
                wrapper.like(columnPrefix + "frame_src", this.getFrameSrc().substring(1, this.getFrameSrc().length() - 1));
            } else if (this.getFrameSrc().startsWith("%") && !this.getFrameSrc().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "frame_src", this.getFrameSrc().substring(1));
            } else if (this.getFrameSrc().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "frame_src", this.getFrameSrc().substring(0, this.getFrameSrc().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "frame_src", this.getFrameSrc());
            }
        }
        wrapper.eq(this.getKeepAlive() != null, columnPrefix + "keep_alive", this.getKeepAlive());
        wrapper.eq(this.getHidden() != null, columnPrefix + "hidden", this.getHidden());
        if (this.getComponent() != null) {
            if (this.getComponent().startsWith("%") && this.getComponent().endsWith("%")) {
                wrapper.like(columnPrefix + "component", this.getComponent().substring(1, this.getComponent().length() - 1));
            } else if (this.getComponent().startsWith("%") && !this.getComponent().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "component", this.getComponent().substring(1));
            } else if (this.getComponent().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "component", this.getComponent().substring(0, this.getComponent().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "component", this.getComponent());
            }
        }
        if (this.getTitle() != null) {
            if (this.getTitle().startsWith("%") && this.getTitle().endsWith("%")) {
                wrapper.like(columnPrefix + "title", this.getTitle().substring(1, this.getTitle().length() - 1));
            } else if (this.getTitle().startsWith("%") && !this.getTitle().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "title", this.getTitle().substring(1));
            } else if (this.getTitle().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "title", this.getTitle().substring(0, this.getTitle().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "title", this.getTitle());
            }
        }
        if (this.getIcon() != null) {
            if (this.getIcon().startsWith("%") && this.getIcon().endsWith("%")) {
                wrapper.like(columnPrefix + "icon", this.getIcon().substring(1, this.getIcon().length() - 1));
            } else if (this.getIcon().startsWith("%") && !this.getIcon().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "icon", this.getIcon().substring(1));
            } else if (this.getIcon().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "icon", this.getIcon().substring(0, this.getIcon().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "icon", this.getIcon());
            }
        }
        wrapper.eq(this.getSortOrder() != null, columnPrefix + "sort_order", this.getSortOrder());
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
