/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：优惠券信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.CouponTypeEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.CouponInfo;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class CouponInfoParam extends BaseParam<CouponInfo> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 优惠券名称
     */
    @Parameter(description = "优惠券名称")
    private Long couponName;
    /**
     * 优惠券类型
     */
    @Parameter(description = "优惠券类型")
    private CouponTypeEnum couponType;
    /**
     * 优惠券类型 IN值List
     */
    @Parameter(description = "优惠券类型 IN值List")
    private List<String> couponTypeList;
    /**
     * 优惠金额/折扣
     */
    @Parameter(description = "优惠金额/折扣")
    private java.math.BigDecimal couponDiscount;
    /**
     * 优惠券开始时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "优惠券开始时间")
    private java.util.Date couponStartDate;
    /**
     * 优惠券开始时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "优惠券开始时间 下限值(大于等于)")
    private java.util.Date couponStartDateFrom;
    /**
     * 优惠券开始时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "优惠券开始时间 上限值(小于)")
    private java.util.Date couponStartDateTo;
    /**
     * 优惠券结束时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "优惠券结束时间")
    private java.util.Date couponEndDate;
    /**
     * 优惠券结束时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "优惠券结束时间 下限值(大于等于)")
    private java.util.Date couponEndDateFrom;
    /**
     * 优惠券结束时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "优惠券结束时间 上限值(小于)")
    private java.util.Date couponEndDateTo;
    /**
     * 是否删除
     */
    @Parameter(description = "是否删除")
    private YesNoEnum deleteStatus;
    /**
     * 是否删除 IN值List
     */
    @Parameter(description = "是否删除 IN值List")
    private List<String> deleteStatusList;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<CouponInfo> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<CouponInfo> toQueryWrapper(String columnPrefix) {
        QueryWrapper<CouponInfo> wrapper = Wrappers.<CouponInfo>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getCouponName() != null, columnPrefix + "coupon_name", this.getCouponName());
        wrapper.eq(this.getCouponType() != null, columnPrefix + "coupon_type", this.getCouponType());
        wrapper.in(this.getCouponTypeList() != null && this.getCouponTypeList().size() > 0, columnPrefix + "coupon_type", this.getCouponTypeList());
        wrapper.eq(this.getCouponDiscount() != null, columnPrefix + "coupon_discount", this.getCouponDiscount());
        wrapper.eq(this.getCouponStartDate() != null, columnPrefix + "coupon_start_date", this.getCouponStartDate());
        wrapper.ge(this.getCouponStartDateFrom() != null, columnPrefix + "coupon_start_date", this.getCouponStartDateFrom());
        wrapper.lt(this.getCouponStartDateTo() != null, columnPrefix + "coupon_start_date", this.getCouponStartDateTo());
        wrapper.eq(this.getCouponEndDate() != null, columnPrefix + "coupon_end_date", this.getCouponEndDate());
        wrapper.ge(this.getCouponEndDateFrom() != null, columnPrefix + "coupon_end_date", this.getCouponEndDateFrom());
        wrapper.lt(this.getCouponEndDateTo() != null, columnPrefix + "coupon_end_date", this.getCouponEndDateTo());
        wrapper.eq(this.getDeleteStatus() != null, columnPrefix + "delete_status", this.getDeleteStatus());
        wrapper.in(this.getDeleteStatusList() != null && this.getDeleteStatusList().size() > 0, columnPrefix + "delete_status", this.getDeleteStatusList());
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
