/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：科室信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.DepartmentLevelEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.DepartmentInfo;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class DepartmentInfoParam extends BaseParam<DepartmentInfo> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 科室名称
     */
    @Parameter(description = "科室名称")
    private Long departmentName;
    /**
     * 科室介绍
     */
    @Parameter(description = "科室介绍")
    private Long departmentIntroduce;
    /**
     * 科室层级
     */
    @Parameter(description = "科室层级")
    private DepartmentLevelEnum departmentLevel;
    /**
     * 科室层级 IN值List
     */
    @Parameter(description = "科室层级 IN值List")
    private List<String> departmentLevelList;
    /**
     * 上级科室id
     */
    @Parameter(description = "上级科室id")
    private Long parentId;
    /**
     * 是否隐藏
     */
    @Parameter(description = "是否隐藏")
    private YesNoEnum hiddenStatus;
    /**
     * 是否隐藏 IN值List
     */
    @Parameter(description = "是否隐藏 IN值List")
    private List<String> hiddenStatusList;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<DepartmentInfo> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<DepartmentInfo> toQueryWrapper(String columnPrefix) {
        QueryWrapper<DepartmentInfo> wrapper = Wrappers.<DepartmentInfo>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getDepartmentName() != null, columnPrefix + "department_name", this.getDepartmentName());
        wrapper.eq(this.getDepartmentIntroduce() != null, columnPrefix + "department_introduce", this.getDepartmentIntroduce());
        wrapper.eq(this.getDepartmentLevel() != null, columnPrefix + "department_level", this.getDepartmentLevel());
        wrapper.in(this.getDepartmentLevelList() != null && this.getDepartmentLevelList().size() > 0, columnPrefix + "department_level", this.getDepartmentLevelList());
        wrapper.eq(this.getParentId() != null, columnPrefix + "parent_id", this.getParentId());
        wrapper.eq(this.getHiddenStatus() != null, columnPrefix + "hidden_status", this.getHiddenStatus());
        wrapper.in(this.getHiddenStatusList() != null && this.getHiddenStatusList().size() > 0, columnPrefix + "hidden_status", this.getHiddenStatusList());
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
