/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：医院信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.HospitalLevelEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.HospitalInfo;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class HospitalInfoParam extends BaseParam<HospitalInfo> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 医院名称
     */
    @Parameter(description = "医院名称")
    private Long hospitalName;
    /**
     * 医院等级
     */
    @Parameter(description = "医院等级")
    private HospitalLevelEnum hospitalLevel;
    /**
     * 医院等级 IN值List
     */
    @Parameter(description = "医院等级 IN值List")
    private List<String> hospitalLevelList;
    /**
     * 医院地址
     */
    @Parameter(description = "医院地址")
    private String address;
    /**
     * 医院联系方式
     */
    @Parameter(description = "医院联系方式")
    private String hospitalTel;
    /**
     * 医院介绍
     */
    @Parameter(description = "医院介绍")
    private String hospitalIntroduce;
    /**
     * 是否删除
     */
    @Parameter(description = "是否删除")
    private YesNoEnum deleteStatus;
    /**
     * 是否删除 IN值List
     */
    @Parameter(description = "是否删除 IN值List")
    private List<String> deleteStatusList;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<HospitalInfo> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<HospitalInfo> toQueryWrapper(String columnPrefix) {
        QueryWrapper<HospitalInfo> wrapper = Wrappers.<HospitalInfo>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getHospitalName() != null, columnPrefix + "hospital_name", this.getHospitalName());
        wrapper.eq(this.getHospitalLevel() != null, columnPrefix + "hospital_level", this.getHospitalLevel());
        wrapper.in(this.getHospitalLevelList() != null && this.getHospitalLevelList().size() > 0, columnPrefix + "hospital_level", this.getHospitalLevelList());
        if (this.getAddress() != null) {
            if (this.getAddress().startsWith("%") && this.getAddress().endsWith("%")) {
                wrapper.like(columnPrefix + "address", this.getAddress().substring(1, this.getAddress().length() - 1));
            } else if (this.getAddress().startsWith("%") && !this.getAddress().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "address", this.getAddress().substring(1));
            } else if (this.getAddress().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "address", this.getAddress().substring(0, this.getAddress().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "address", this.getAddress());
            }
        }
        if (this.getHospitalTel() != null) {
            if (this.getHospitalTel().startsWith("%") && this.getHospitalTel().endsWith("%")) {
                wrapper.like(columnPrefix + "hospital_tel", this.getHospitalTel().substring(1, this.getHospitalTel().length() - 1));
            } else if (this.getHospitalTel().startsWith("%") && !this.getHospitalTel().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "hospital_tel", this.getHospitalTel().substring(1));
            } else if (this.getHospitalTel().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "hospital_tel", this.getHospitalTel().substring(0, this.getHospitalTel().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "hospital_tel", this.getHospitalTel());
            }
        }
        if (this.getHospitalIntroduce() != null) {
            if (this.getHospitalIntroduce().startsWith("%") && this.getHospitalIntroduce().endsWith("%")) {
                wrapper.like(columnPrefix + "hospital_introduce", this.getHospitalIntroduce().substring(1, this.getHospitalIntroduce().length() - 1));
            } else if (this.getHospitalIntroduce().startsWith("%") && !this.getHospitalIntroduce().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "hospital_introduce", this.getHospitalIntroduce().substring(1));
            } else if (this.getHospitalIntroduce().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "hospital_introduce", this.getHospitalIntroduce().substring(0, this.getHospitalIntroduce().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "hospital_introduce", this.getHospitalIntroduce());
            }
        }
        wrapper.eq(this.getDeleteStatus() != null, columnPrefix + "delete_status", this.getDeleteStatus());
        wrapper.in(this.getDeleteStatusList() != null && this.getDeleteStatusList().size() > 0, columnPrefix + "delete_status", this.getDeleteStatusList());
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
