/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：订单支付表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.PayStateEnum;
import com.xwd.hospital.server.enums.PayPathEnum;
import com.xwd.hospital.server.domain.OrderPay;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class OrderPayParam extends BaseParam<OrderPay> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 订单id
     */
    @Parameter(description = "订单id")
    private Long orderId;
    /**
     * 订单号
     */
    @Parameter(description = "订单号")
    private String orderNo;
    /**
     * 支付流水号
     */
    @Parameter(description = "支付流水号")
    private String payNo;
    /**
     * 支付状态
     */
    @Parameter(description = "支付状态")
    private PayStateEnum payState;
    /**
     * 支付状态 IN值List
     */
    @Parameter(description = "支付状态 IN值List")
    private List<String> payStateList;
    /**
     * 支付方式类型
     */
    @Parameter(description = "支付方式类型")
    private PayPathEnum payPath;
    /**
     * 支付方式类型 IN值List
     */
    @Parameter(description = "支付方式类型 IN值List")
    private List<String> payPathList;
    /**
     * 支付金额
     */
    @Parameter(description = "支付金额")
    private java.math.BigDecimal payMoney;
    /**
     * 支付时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "支付时间")
    private java.util.Date payTime;
    /**
     * 支付时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "支付时间 下限值(大于等于)")
    private java.util.Date payTimeFrom;
    /**
     * 支付时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "支付时间 上限值(小于)")
    private java.util.Date payTimeTo;
    /**
     * 完成时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "完成时间")
    private java.util.Date completeTime;
    /**
     * 完成时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "完成时间 下限值(大于等于)")
    private java.util.Date completeTimeFrom;
    /**
     * 完成时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "完成时间 上限值(小于)")
    private java.util.Date completeTimeTo;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 创建时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间")
    private java.util.Date createTime;
    /**
     * 创建时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     * 创建时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "创建时间 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 更新时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间")
    private java.util.Date updateTime;
    /**
     * 更新时间 下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     * 更新时间 上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "更新时间 上限值(小于)")
    private java.util.Date updateTimeTo;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<OrderPay> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<OrderPay> toQueryWrapper(String columnPrefix) {
        QueryWrapper<OrderPay> wrapper = Wrappers.<OrderPay>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getOrderId() != null, columnPrefix + "order_id", this.getOrderId());
        if (this.getOrderNo() != null) {
            if (this.getOrderNo().startsWith("%") && this.getOrderNo().endsWith("%")) {
                wrapper.like(columnPrefix + "order_no", this.getOrderNo().substring(1, this.getOrderNo().length() - 1));
            } else if (this.getOrderNo().startsWith("%") && !this.getOrderNo().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "order_no", this.getOrderNo().substring(1));
            } else if (this.getOrderNo().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "order_no", this.getOrderNo().substring(0, this.getOrderNo().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "order_no", this.getOrderNo());
            }
        }
        if (this.getPayNo() != null) {
            if (this.getPayNo().startsWith("%") && this.getPayNo().endsWith("%")) {
                wrapper.like(columnPrefix + "pay_no", this.getPayNo().substring(1, this.getPayNo().length() - 1));
            } else if (this.getPayNo().startsWith("%") && !this.getPayNo().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "pay_no", this.getPayNo().substring(1));
            } else if (this.getPayNo().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "pay_no", this.getPayNo().substring(0, this.getPayNo().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "pay_no", this.getPayNo());
            }
        }
        wrapper.eq(this.getPayState() != null, columnPrefix + "pay_state", this.getPayState());
        wrapper.in(this.getPayStateList() != null && this.getPayStateList().size() > 0, columnPrefix + "pay_state", this.getPayStateList());
        wrapper.eq(this.getPayPath() != null, columnPrefix + "pay_path", this.getPayPath());
        wrapper.in(this.getPayPathList() != null && this.getPayPathList().size() > 0, columnPrefix + "pay_path", this.getPayPathList());
        wrapper.eq(this.getPayMoney() != null, columnPrefix + "pay_money", this.getPayMoney());
        wrapper.eq(this.getPayTime() != null, columnPrefix + "pay_time", this.getPayTime());
        wrapper.ge(this.getPayTimeFrom() != null, columnPrefix + "pay_time", this.getPayTimeFrom());
        wrapper.lt(this.getPayTimeTo() != null, columnPrefix + "pay_time", this.getPayTimeTo());
        wrapper.eq(this.getCompleteTime() != null, columnPrefix + "complete_time", this.getCompleteTime());
        wrapper.ge(this.getCompleteTimeFrom() != null, columnPrefix + "complete_time", this.getCompleteTimeFrom());
        wrapper.lt(this.getCompleteTimeTo() != null, columnPrefix + "complete_time", this.getCompleteTimeTo());
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        return wrapper;
    }

}
