/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：角色权限对应表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.domain.RoleAuthority;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class RoleAuthorityParam extends BaseParam<RoleAuthority> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * sys_role.id
     */
    @Parameter(description = "sys_role.id")
    private Long roleId;
    /**
     * sys_authority.id
     */
    @Parameter(description = "sys_authority.id")
    private Long authorityId;


    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<RoleAuthority> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<RoleAuthority> toQueryWrapper(String columnPrefix) {
        QueryWrapper<RoleAuthority> wrapper = Wrappers.<RoleAuthority>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        wrapper.eq(this.getRoleId() != null, columnPrefix + "role_id", this.getRoleId());
        wrapper.eq(this.getAuthorityId() != null, columnPrefix + "authority_id", this.getAuthorityId());
        return wrapper;
    }

}
