/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：用户表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.rest.req;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Parameter;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import com.xwd.hospital.server.base.BaseParam;
import com.xwd.hospital.server.enums.UserTypeEnum;
import com.xwd.hospital.server.enums.RegisterSourceEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.User;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
public class UserParam extends BaseParam<User> {
    /**
     * Id
     */
    @Parameter(description = "Id")
    private Long id;
    /**
     * Id IN值List
     */
    @Parameter(description = "Id IN值List")
    private List<Long> idList;
    /**
     * 用户名
     */
    @Parameter(description = "用户名")
    private String username;
    /**
     * 微信open_id
     */
    @Parameter(description = "微信open_id")
    private String openId;
    /**
     * 用户类型
     */
    @Parameter(description = "用户类型")
    private UserTypeEnum userType;
    /**
     * 用户类型 IN值List
     */
    @Parameter(description = "用户类型 IN值List")
    private List<String> userTypeList;
    /**
     * 注册来源
     */
    @Parameter(description = "注册来源")
    private RegisterSourceEnum registerSource;
    /**
     * 注册来源 IN值List
     */
    @Parameter(description = "注册来源 IN值List")
    private List<String> registerSourceList;
    /**
     * 关联对象(doctor_info、user_info)
     */
    @Parameter(description = "关联对象(doctor_info、user_info)")
    private Long objId;
    /**
     * 是否删除
     */
    @Parameter(description = "是否删除")
    private YesNoEnum deleteStatus;
    /**
     * 是否删除 IN值List
     */
    @Parameter(description = "是否删除 IN值List")
    private List<String> deleteStatusList;
    /**
     * 密码
     */
    @Parameter(description = "密码")
    private String password;
    /**
     * 姓名
     */
    @Parameter(description = "姓名")
    private String realName;
    /**
     * 手机号
     */
    @Parameter(description = "手机号")
    private String phone;
    /**
     * 头像
     */
    @Parameter(description = "头像")
    private String avatar;
    /**
     * 操作人Id
     */
    @Parameter(description = "操作人Id")
    private Long editorId;
    /**
     * 操作人
     */
    @Parameter(description = "操作人")
    private String editorName;
    /**
     * 
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "")
    private java.util.Date createTime;
    /**
     *  下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = " 下限值(大于等于)")
    private java.util.Date createTimeFrom;
    /**
     *  上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = " 上限值(小于)")
    private java.util.Date createTimeTo;
    /**
     * 
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = "")
    private java.util.Date updateTime;
    /**
     *  下限值(大于等于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = " 下限值(大于等于)")
    private java.util.Date updateTimeFrom;
    /**
     *  上限值(小于)
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Parameter(description = " 上限值(小于)")
    private java.util.Date updateTimeTo;

    @Parameter(description = "角色")
    private String role;

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<User> toQueryWrapper() {
        return this.toQueryWrapper("");
    }

    /**
     * 将查询参数转化为查询Wrapper
     */
    @Override
    public QueryWrapper<User> toQueryWrapper(String columnPrefix) {
        QueryWrapper<User> wrapper = Wrappers.<User>query();
        wrapper.eq(this.getId() != null, columnPrefix + "id", this.getId());
        wrapper.in(this.getIdList() != null && this.getIdList().size() > 0, columnPrefix + "id", this.getIdList());
        if (this.getUsername() != null) {
            if (this.getUsername().startsWith("%") && this.getUsername().endsWith("%")) {
                wrapper.like(columnPrefix + "username", this.getUsername().substring(1, this.getUsername().length() - 1));
            } else if (this.getUsername().startsWith("%") && !this.getUsername().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "username", this.getUsername().substring(1));
            } else if (this.getUsername().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "username", this.getUsername().substring(0, this.getUsername().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "username", this.getUsername());
            }
        }
        if (this.getOpenId() != null) {
            if (this.getOpenId().startsWith("%") && this.getOpenId().endsWith("%")) {
                wrapper.like(columnPrefix + "open_id", this.getOpenId().substring(1, this.getOpenId().length() - 1));
            } else if (this.getOpenId().startsWith("%") && !this.getOpenId().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "open_id", this.getOpenId().substring(1));
            } else if (this.getOpenId().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "open_id", this.getOpenId().substring(0, this.getOpenId().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "open_id", this.getOpenId());
            }
        }
        wrapper.eq(this.getUserType() != null, columnPrefix + "user_type", this.getUserType());
        wrapper.in(this.getUserTypeList() != null && this.getUserTypeList().size() > 0, columnPrefix + "user_type", this.getUserTypeList());
        wrapper.eq(this.getRegisterSource() != null, columnPrefix + "register_source", this.getRegisterSource());
        wrapper.in(this.getRegisterSourceList() != null && this.getRegisterSourceList().size() > 0, columnPrefix + "register_source", this.getRegisterSourceList());
        wrapper.eq(this.getObjId() != null, columnPrefix + "obj_id", this.getObjId());
        wrapper.eq(this.getDeleteStatus() != null, columnPrefix + "delete_status", this.getDeleteStatus());
        wrapper.in(this.getDeleteStatusList() != null && this.getDeleteStatusList().size() > 0, columnPrefix + "delete_status", this.getDeleteStatusList());
        if (this.getPassword() != null) {
            if (this.getPassword().startsWith("%") && this.getPassword().endsWith("%")) {
                wrapper.like(columnPrefix + "password", this.getPassword().substring(1, this.getPassword().length() - 1));
            } else if (this.getPassword().startsWith("%") && !this.getPassword().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "password", this.getPassword().substring(1));
            } else if (this.getPassword().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "password", this.getPassword().substring(0, this.getPassword().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "password", this.getPassword());
            }
        }
        if (this.getRealName() != null) {
            if (this.getRealName().startsWith("%") && this.getRealName().endsWith("%")) {
                wrapper.like(columnPrefix + "real_name", this.getRealName().substring(1, this.getRealName().length() - 1));
            } else if (this.getRealName().startsWith("%") && !this.getRealName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "real_name", this.getRealName().substring(1));
            } else if (this.getRealName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "real_name", this.getRealName().substring(0, this.getRealName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "real_name", this.getRealName());
            }
        }
        if (this.getPhone() != null) {
            if (this.getPhone().startsWith("%") && this.getPhone().endsWith("%")) {
                wrapper.like(columnPrefix + "phone", this.getPhone().substring(1, this.getPhone().length() - 1));
            } else if (this.getPhone().startsWith("%") && !this.getPhone().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "phone", this.getPhone().substring(1));
            } else if (this.getPhone().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "phone", this.getPhone().substring(0, this.getPhone().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "phone", this.getPhone());
            }
        }
        if (this.getAvatar() != null) {
            if (this.getAvatar().startsWith("%") && this.getAvatar().endsWith("%")) {
                wrapper.like(columnPrefix + "avatar", this.getAvatar().substring(1, this.getAvatar().length() - 1));
            } else if (this.getAvatar().startsWith("%") && !this.getAvatar().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "avatar", this.getAvatar().substring(1));
            } else if (this.getAvatar().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "avatar", this.getAvatar().substring(0, this.getAvatar().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "avatar", this.getAvatar());
            }
        }
        wrapper.eq(this.getEditorId() != null, columnPrefix + "editor_id", this.getEditorId());
        if (this.getEditorName() != null) {
            if (this.getEditorName().startsWith("%") && this.getEditorName().endsWith("%")) {
                wrapper.like(columnPrefix + "editor_name", this.getEditorName().substring(1, this.getEditorName().length() - 1));
            } else if (this.getEditorName().startsWith("%") && !this.getEditorName().endsWith("%")) {
                wrapper.likeLeft(columnPrefix + "editor_name", this.getEditorName().substring(1));
            } else if (this.getEditorName().endsWith("%")) {
                wrapper.likeRight(columnPrefix + "editor_name", this.getEditorName().substring(0, this.getEditorName().length() - 1));
            } else {
                wrapper.eq(columnPrefix + "editor_name", this.getEditorName());
            }
        }
        wrapper.eq(this.getCreateTime() != null, columnPrefix + "create_time", this.getCreateTime());
        wrapper.ge(this.getCreateTimeFrom() != null, columnPrefix + "create_time", this.getCreateTimeFrom());
        wrapper.lt(this.getCreateTimeTo() != null, columnPrefix + "create_time", this.getCreateTimeTo());
        wrapper.eq(this.getUpdateTime() != null, columnPrefix + "update_time", this.getUpdateTime());
        wrapper.ge(this.getUpdateTimeFrom() != null, columnPrefix + "update_time", this.getUpdateTimeFrom());
        wrapper.lt(this.getUpdateTimeTo() != null, columnPrefix + "update_time", this.getUpdateTimeTo());
        wrapper.inSql(!org.springframework.util.StringUtils.isEmpty(this.getRole()), columnPrefix + "id", "select ur.user_id from sys_user_role as ur left join sys_role as r on ur.role_id = r.id where r.name = '" + role + "'");
        return wrapper;
    }

}
