/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：订单表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service;

import java.util.List;
import com.xwd.hospital.server.base.BaseService;
import com.xwd.hospital.server.domain.Order;
import com.xwd.hospital.server.dto.CreateOrderDto;
import com.xwd.hospital.server.dto.OrderDto;
import com.xwd.hospital.server.enums.OrderStateEnum;
import com.xwd.hospital.server.rest.req.OrderParam;
import org.springframework.data.domain.jaxb.SpringDataJaxb;

public interface OrderService extends BaseService<Order> {

    List<OrderDto> queryOrderListForMiniApp(OrderStateEnum state);

    Order createOrder(CreateOrderDto createOrderDto);

    void cancelOrder(String orderNo);
}
