/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：医生信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.service.impl;

import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;
import java.util.Collection;

import com.xwd.hospital.server.domain.ArticleInfo;
import com.xwd.hospital.server.domain.DepartmentInfo;
import com.xwd.hospital.server.dto.DoctorDto;
import com.xwd.hospital.server.rest.req.DoctorSearchParam;
import com.xwd.hospital.server.service.DepartmentInfoService;
import jakarta.annotation.Resource;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.xwd.hospital.server.service.DoctorInfoService;
import com.xwd.hospital.server.repository.DoctorInfoMapper;
import com.xwd.hospital.server.repository.base.DoctorInfoBaseMapper;
import com.xwd.hospital.server.domain.DoctorInfo;
import com.xwd.hospital.server.rest.req.DoctorInfoParam;

@Service
public class DoctorInfoServiceImpl extends ServiceImpl<DoctorInfoMapper, DoctorInfo> implements DoctorInfoService {
    @Resource
    private DepartmentInfoService departmentInfoService;

    @Override
    public int updateAllFieldsById(DoctorInfo entity) {
        return this.getBaseMapper().updateAllFieldsById(entity);
    }

    /**
     * 批量插入
     *
     * @param entityList ignore
     * @param batchSize  ignore
     * @return ignore
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveBatch(Collection<DoctorInfo> entityList, int batchSize) {
        String sqlStatement = SqlHelper.getSqlStatement(DoctorInfoBaseMapper.class, SqlMethod.INSERT_ONE);
        return executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    @Override
    public List<DoctorDto> queryDoctorList(DoctorSearchParam param) {
        if(!StringUtils.isBlank(param.getDepartmentName()) && null == param.getDepartmentId()){
            DepartmentInfo department = departmentInfoService.getOne(Wrappers.<DepartmentInfo>query().eq("department_name", param.getDepartmentName()));
            param.setDepartmentId(department.getId());
        }

        return this.getBaseMapper().queryDoctorList(param.getSickness(),param.getDoctorName(),param.getDepartmentId());
    }
}
