package com.xwd.hospital.server.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xwd.hospital.server.domain.ArticleInfo;
import com.xwd.hospital.server.domain.DoctorInfo;
import com.xwd.hospital.server.domain.Order;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.dto.DoctorMiniAppHomeDto;
import com.xwd.hospital.server.dto.PatientMiniAppHomeDto;
import com.xwd.hospital.server.enums.OrderStateEnum;
import com.xwd.hospital.server.service.ArticleInfoService;
import com.xwd.hospital.server.service.DoctorInfoService;
import com.xwd.hospital.server.service.HomeService;
import com.xwd.hospital.server.service.OrderService;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class HomeServiceImpl implements HomeService {
    @Resource
    private DoctorInfoService doctorInfoService;
    @Resource
    private OrderService orderService;
    @Resource
    private ArticleInfoService articleInfoService;

    @Override
    public PatientMiniAppHomeDto patientMiniAppHome() {

        return null;
    }

    @Override
    public DoctorMiniAppHomeDto doctorMiniAppHome(Long doctorId) {
        DoctorMiniAppHomeDto doctorMiniAppHomeDto = new DoctorMiniAppHomeDto();
        DoctorInfo doctorInfo = doctorInfoService.getById(doctorId);
        doctorMiniAppHomeDto.setDoctorName(doctorInfo.getDoctorName());
        doctorMiniAppHomeDto.setAvatar(doctorInfo.getUser().getAvatar());
        doctorMiniAppHomeDto.setHospitalName(doctorInfo.getMedicalQualification().getHospital().getHospitalName());
        doctorMiniAppHomeDto.setDepartmentName(doctorInfo.getMedicalQualification().getDepartment().getDepartmentName());
        doctorMiniAppHomeDto.setDoctorTitle(doctorInfo.getMedicalQualification().getTitle().getName());
        //文章
        List<ArticleInfo> articleInfoList = articleInfoService.list(Wrappers.<ArticleInfo>query().orderByDesc("create_time").last("LIMIT 5"));
        doctorMiniAppHomeDto.setArticleInfoList(articleInfoList);
        //问诊订单
        //待确认订单
        List<Order> orderList = orderService.list(Wrappers.<Order>query().eq("doctor_id", doctorId).eq("order_state", OrderStateEnum.TO_CONFIRM).orderByDesc("create_time").last("LIMIT 5"));
        doctorMiniAppHomeDto.setOrderList(orderList);
        return doctorMiniAppHomeDto;
    }
}
