package com.xwd.hospital.server.service.impl;

import com.xwd.hospital.server.service.RedisService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

@Service
public class RedisServiceImpl implements RedisService {
    @Autowired
    private RedisTemplate<String,String> redisTemplate;

    @Override
    public void set(String key, String value) {
        redisTemplate.opsForValue().set(key,value);
    }

    @Override
    public String get(String key) {
        String value= (String) redisTemplate.opsForValue().get(key);

        return value;
    }

    @Override
    public void setExpire(String key, String value,long time,TimeUnit timeUnit) {
        redisTemplate.opsForValue().set(key,value,time, timeUnit);
    }
}
