package com.xwd.hospital.server.service.impl;

import com.xwd.hospital.server.constants.Constant;
import com.xwd.hospital.server.service.RedisService;
import com.xwd.hospital.server.service.SmsService;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Service;

import java.util.Random;
import java.util.concurrent.TimeUnit;

@Service
public class SmsServiceImpl implements SmsService {
    @Resource
    private RedisService redisService;

    @Override
    public boolean sendSms(String phoneNumber) {
        //随机生成六位数字验证码
        Random random = new Random();
        // 生成一个100000到999999之间的随机整数
        int randomNumber = random.nextInt(900000) + 100000;
        //TODO 调用短信sdk发送短信

        //存入redis中，缓存默认5分钟失效
        redisService.setExpire(Constant.SMS_PREFIX+phoneNumber,String.valueOf(randomNumber),5, TimeUnit.MINUTES);
        return true;
    }
}
