/**
 * 项目：互联网医疗
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.util;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import lombok.SneakyThrows;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.UUID;

public final class FileUtils {
    private static final String FILE_EXTENSION_SEPARATOR = ".";

    /**
     * 文件上传
     * @param file
     * @param username
     * @return
     */
    @SneakyThrows
    public static String upload(MultipartFile file, String username, String uploadBasePath) {
        String localFileName = String.format("/%s/%s/%s.%s",
                username,
                LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")),
                UUID.randomUUID(),
                Files.getFileExtension(Objects.requireNonNull(file.getOriginalFilename()))
        );
        if(localFileName.endsWith(FILE_EXTENSION_SEPARATOR)) {
            localFileName = localFileName + "jpg";
        }
        File uploadFile = new File(uploadBasePath, localFileName);
        Files.createParentDirs(uploadFile);
        Files.write(ByteStreams.toByteArray(file.getInputStream()), uploadFile);
        return localFileName;
    }

}
