/**
 * 项目：互联网医疗
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.util;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringUtils {

    private static Pattern CamelPattern = Pattern.compile("[A-Z]");

    private static Pattern UnderscorePattern = Pattern.compile("_\\w");

    /**
     * 驼峰转下划线
     * @param str
     * @return
     */
    public static String camelToUnderScore(String str) {
        Matcher matcher = CamelPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    /**
     * 下划线转驼峰
     * @param str
     * @return
     */
    public static String underScoreToCamel(String str) {
        Matcher matcher = UnderscorePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String group = matcher.group(0);
            matcher.appendReplacement(sb, group.substring(0, 1).toUpperCase() + group.substring(1));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    /**
     * UUID
     * @return
     */
    public static String uuid() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replace("-", "");
    }

}
