drop table if exists `pms_doctor_info`;
create table `pms_doctor_info`
(
  id int(11) auto_increment not null comment 'Id',
  user_id int(11) not null comment '用户Id',
  medical_qualification_id int(11) null comment '医生医疗资质Id',
  doctor_state varchar(50) not null default 'NORMAL' comment '医生状态 [NORMAL.正常 DISABLED.失效]',
  doctor_name varchar(255) not null comment '医生姓名',
  sex varchar(50) not null default 'MALE' comment '性别 [MALE.男 FEMALE.女]',
  id_no varchar(255) not null comment '身份证号码',
  born_date varchar(255) not null comment '出生日期',
  phone_number varchar(255) null comment '手机号码',
  expertise_area varchar(255) null comment '擅长领域',
  introduction varchar(255) null comment '简介',
  id_card_picture_front varchar(255) null comment '身份证图片正面',
  id_card_picture_back varchar(255) null comment '身份证图片背面',
  delete_status varchar(50) not null default 'NO' comment '是否删除 [YES.是 NO.否]',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='医生信息表';

drop table if exists `pms_medical_qualifications`;
create table `pms_medical_qualifications`
(
  id int(11) auto_increment not null comment 'Id',
  doctor_id int(11) not null comment '医生Id',
  hospital_id int(11) not null comment '医院Id',
  department_id int(11) not null comment '科室Id',
  title varchar(50) not null default 'RESIDENT_DOCTOR' comment '职称 [RESIDENT_DOCTOR.住院医师 ATTENDING_DOCTOR.主治医师 ASSOCIATE_DOCTOR.副主任医师 SENIOR_DOCTOR.主任医师]',
  audit_state varchar(50) not null default 'TO_AUDIT' comment '审核状态 [TO_AUDIT.待审核 AUDIT_SUCCESS.审核通过 AUDIT_FAIL.审核失败]',
  certificate_picture varchar(255) not null comment '医疗资格证件图片',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='医生医疗资质信息表';

drop table if exists `pms_medical_qualifications_picture`;
create table `pms_medical_qualifications_picture`
(
  id int(11) auto_increment not null comment 'Id',
  doctor_id int(11) not null comment '医生Id',
  medical_qualification_id int(11) not null comment '医生医疗资质Id',
  certificate_picture varchar(255) not null comment '医疗资格证件图片',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='医生医疗资质图片表';

drop table if exists `pms_doctor_family_address_info`;
create table `pms_doctor_family_address_info`
(
  id int(11) auto_increment not null comment 'Id',
  doctor_id int(11) not null comment '医生Id',
  name varchar(255) not null comment '姓名',
  phone_number varchar(255) not null comment '手机号码',
  province varchar(255) not null comment '省',
  city varchar(255) not null comment '市',
  district varchar(255) not null comment '区',
  detail_address varchar(255) not null comment '详细地址',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='家庭医生地址关系表';

drop table if exists `pms_article_info`;
create table `pms_article_info`
(
  id int(11) auto_increment not null comment 'Id',
  article_author varchar(255) not null comment '文章作者',
  article_title varchar(255) not null comment '文章标题',
  article_content text not null comment '文章内容',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='学术文章';

drop table if exists `pms_user_info`;
create table `pms_user_info`
(
  id int(11) auto_increment not null comment 'Id',
  user_id int(11) not null comment '用户Id',
  name varchar(255) not null comment '姓名',
  sex varchar(50) not null default 'MALE' comment '性别 [MALE.男 FEMALE.女]',
  id_no varchar(255) not null comment '身份证号码',
  born_date varchar(50) not null comment '出生日期',
  phone_number varchar(255) not null comment '手机号码',
  certificate_picture varchar(255) not null comment '证件图片',
  personal_info_filled varchar(50) not null default 'NO' comment '是否完善好个人信息 [YES.是 NO.否]',
  delete_status varchar(50) not null default 'NO' comment '是否删除 [YES.是 NO.否]',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='用户信息表';

drop table if exists `pms_user_address_info`;
create table `pms_user_address_info`
(
  id int(11) auto_increment not null comment 'Id',
  user_info_id int(11) not null comment '用户Id',
  name varchar(255) not null comment '姓名',
  phone_number varchar(255) not null comment '手机号码',
  province varchar(255) not null comment '省',
  city varchar(255) not null comment '市',
  district varchar(255) not null comment '区',
  detail_address varchar(255) not null comment '详细地址',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='用户地址关系表';

drop table if exists `pms_doctor_service_info`;
create table `pms_doctor_service_info`
(
  id int(11) auto_increment not null comment 'Id',
  doctor_id int(11) not null comment '医生Id',
  service_name varchar(50) not null default 'ONLINE_INQUIRY' comment '服务名称 [ONLINE_INQUIRY.在线问诊 PRESCRIPTION.续房开药 TELEPHONE.电话咨询]',
  service_price decimal(12, 2) not null comment '服务价格',
  service_state varchar(50) not null default 'NO' comment '服务状态 [YES.是 NO.否]',
  service_start_time varchar(64) not null comment '每日服务开始时间',
  service_end_time varchar(64) not null comment '每日服务结束时间',
  service_phone_number varchar(255) null comment '服务手机',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='医生服务信息表';

drop table if exists `pms_patient_info`;
create table `pms_patient_info`
(
  id int(11) auto_increment not null comment 'Id',
  user_info_id int(11) not null comment '用户Id',
  relation varchar(50) not null default 'SELF' comment '就诊人关系 [SELF.本人 PARENT.父母 FRIEND.朋友 CHILDREN.孩子 OTHER.其他]',
  patient_name varchar(255) not null comment '就诊人姓名',
  sex varchar(50) not null default 'MALE' comment '性别 [MALE.男 FEMALE.女]',
  id_no varchar(255) not null comment '身份证号码',
  phone_number varchar(255) null comment '手机号码',
  born_date varchar(255) not null comment '出生日期',
  guardian_state varchar(50) not null default 'NO' comment '是否有监护人 [YES.是 NO.否]',
  guardian_name varchar(255) null comment '就诊人姓名',
  guardian_identification_number varchar(255) null comment '监护人身份证号码',
  guardian_phone_number varchar(255) null comment '监护人手机号码',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='就诊人信息表';

drop table if exists `pms_hospital_info`;
create table `pms_hospital_info`
(
  id int(11) auto_increment not null comment 'Id',
  hospital_name varchar(255) not null comment '医院名称',
  hospital_level varchar(50) not null default 'THIRD_CLASS_GRADE_A' comment '医院等级 [THIRD_CLASS_GRADE_S.三级特等 THIRD_CLASS_GRADE_A.三级甲等 THIRD_CLASS_GRADE_B.三级乙等 THIRD_CLASS_GRADE_C.三级丙等 SECOND_CLASS_GRADE_A.二级甲等 SECOND_CLASS_GRADE_B.二级乙等 SECOND_CLASS_GRADE_C.二级丙等 FIRST_CLASS_GRADE_A.一级甲等 FIRST_CLASS_GRADE_B.一级乙等 FIRST_CLASS_GRADE_C.一级丙等]',
  address varchar(255) not null comment '医院地址',
  hospital_tel varchar(255) not null comment '医院联系方式',
  hospital_introduce text not null comment '医院介绍',
  delete_status varchar(50) not null default 'NO' comment '是否删除 [YES.是 NO.否]',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='医院信息表';

drop table if exists `pms_department_info`;
create table `pms_department_info`
(
  id int(11) auto_increment not null comment 'Id',
  department_name varchar(255) not null comment '科室名称',
  department_introduce varchar(255) not null comment '科室介绍',
  department_level varchar(50) not null default 'FIRST_LEVEL' comment '科室层级 [FIRST_LEVEL.第一层级 SECOND_LEVEL.第二层级]',
  parent_id int(11) null comment '上级科室id',
  hidden_status varchar(50) not null default 'NO' comment '是否隐藏 [YES.是 NO.否]',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='科室信息表';

drop table if exists `pms_medical_report`;
create table `pms_medical_report`
(
  id int(11) auto_increment not null comment 'Id',
  patient_name int(11) not null comment '患者姓名',
  patient_id_no varchar(32) not null comment '患者身份证号码',
  sex varchar(50) not null default 'MALE' comment '性别 [MALE.男 FEMALE.女]',
  age int(255) not null comment '患者年龄',
  report_item varchar(512) not null comment '影像报告项目',
  report_declare varchar(512) not null comment '影像说明',
  report_hospital varchar(255) not null comment '报告医院',
  report_doctor varchar(255) not null comment '报告医生',
  report_time datetime not null comment '报告时间',
  report_state varchar(50) not null default 'TO_INTERPRET' comment '影像报告状态 [TO_INTERPRET.待解读 INTERPRETED.已解读 CONFIRMED.已确认]',
  doctor_asks varchar(512) null comment '医生医嘱',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='影像报告表';

drop table if exists `pms_medical_report_picture`;
create table `pms_medical_report_picture`
(
  id int(11) auto_increment not null comment 'Id',
  medical_report_id int(11) not null comment '影像报告Id',
  report_picture varchar(255) not null comment 'CT影像图片',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='影像图片表';

drop table if exists `pms_coupon_info`;
create table `pms_coupon_info`
(
  id int(11) auto_increment not null comment 'Id',
  coupon_name int(11) not null comment '优惠券名称',
  coupon_type varchar(50) not null default 'FULL_DISCOUNT' comment '优惠券类型 [FULL_DISCOUNT.满减券]',
  coupon_discount decimal(12, 2) not null comment '优惠金额/折扣',
  coupon_start_date datetime not null comment '优惠券开始时间',
  coupon_end_date datetime not null comment '优惠券结束时间',
  delete_status varchar(50) not null default 'NO' comment '是否删除 [YES.是 NO.否]',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='优惠券信息表';

drop table if exists `pms_user_coupon_info`;
create table `pms_user_coupon_info`
(
  id int(11) auto_increment not null comment 'Id',
  user_info_id int(11) not null comment '用户Id',
  coupon_id int(11) not null comment '优惠券Id',
  coupon_name int(11) not null comment '优惠券名称',
  coupon_type varchar(50) not null default 'FULL_DISCOUNT' comment '优惠券类型 [FULL_DISCOUNT.满减券]',
  coupon_discount decimal(12, 2) not null comment '优惠金额/折扣',
  coupon_start_date datetime not null comment '优惠券开始时间',
  coupon_end_date datetime not null comment '优惠券结束时间',
  coupon_use_state varchar(50) not null default 'YES' comment '优惠券可用状态 [YES.是 NO.否]',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='用户优惠券关系表';

drop table if exists `pms_user_attention_info`;
create table `pms_user_attention_info`
(
  id int(11) auto_increment not null comment 'Id',
  user_info_id int(11) not null comment '用户Id',
  doctor_id int(11) not null comment '医生Id',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='用户关注信息表';

drop table if exists `pms_patient_prescription_info`;
create table `pms_patient_prescription_info`
(
  id int(11) auto_increment not null comment 'Id',
  patient_id int(11) not null comment '就诊人Id',
  hospital_name varchar(255) not null comment '医院名称',
  department_name varchar(255) not null comment '科室名称',
  prescription_time varchar(255) not null comment '处方时间',
  prescription_introduce varchar(255) not null comment '处方说明',
  delete_status varchar(50) not null default 'NO' comment '是否删除 [YES.是 NO.否]',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='就诊人处方信息表';

drop table if exists `pms_patient_prescription_info_picture`;
create table `pms_patient_prescription_info_picture`
(
  id int(11) auto_increment not null comment 'Id',
  patient_prescription_info_id int(11) not null comment '处方信息Id',
  prescription_picture varchar(255) not null comment '处方图片',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='处方信息图片表';

drop table if exists `pms_family_doctor`;
create table `pms_family_doctor`
(
  id int(11) auto_increment not null comment 'Id',
  user_info_id int(11) not null comment '用户Id',
  name varchar(255) not null comment '姓名',
  sex varchar(50) not null default 'MALE' comment '性别 [MALE.男 FEMALE.女]',
  id_no varchar(255) not null comment '身份证号码',
  born_date varchar(255) not null comment '出生日期',
  phone_number varchar(255) not null comment '手机号码',
  family_address varchar(255) not null comment '家庭地址',
  audit_state varchar(50) not null default 'TO_AUDIT' comment '审核状态 [TO_AUDIT.待审核 AUDIT_SUCCESS.审核通过 AUDIT_FAIL.审核失败]',
  doctor_id int(11) null comment '相关联的家庭医生Id',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='家庭医生';

drop table if exists `pms_order`;
create table `pms_order`
(
  id int(11) auto_increment not null comment 'Id',
  user_info_id int(11) not null comment '用户Id',
  doctor_id int(11) not null comment '医生Id',
  patient_id int(11) not null comment '就诊人Id',
  order_no varchar(255) not null comment '订单号',
  order_state varchar(50) not null default 'TO_PAY' comment '订单状态 [TO_PAY.待支付 TO_CONFIRM.待确认 CANCELED.已取消 REJECTED.已驳回 IN_SERVICE.服务中 COMPLETED.已完成]',
  order_type varchar(50) not null default 'ONLINE_INQUIRY' comment '订单类型 [ONLINE_INQUIRY.在线问诊 PRESCRIPTION.续方开药 TELEPHONE.电话咨询]',
  order_price decimal(12, 2) not null comment '订单金额',
  order_discount decimal(12, 2) not null default 0 comment '订单优惠金额',
  order_actual_pay decimal(12, 2) not null comment '订单实际支付金额',
  user_coupon_id int(11) null comment '优惠券Id',
  appointment_date datetime not null comment '预约日期',
  service_start_time varchar(64) not null comment '每日服务开始时间',
  service_end_time varchar(64) not null comment '每日服务结束时间',
  hospital_name varchar(255) not null comment '医院名称',
  department_name varchar(255) not null comment '科室名称',
  doctor_name varchar(255) not null comment '医生姓名',
  patient_name varchar(255) not null comment '就诊人姓名',
  patient_sex varchar(50) not null default 'MALE' comment '性别 [MALE.男 FEMALE.女]',
  patient_id_no varchar(255) not null comment '身份证号码',
  patient_phone_number varchar(255) null comment '就诊人手机号码',
  patient_born_date varchar(64) not null comment '就诊人出生日期',
  patient_self_introduce varchar(255) not null comment '患者自述',
  cancel_reason varchar(255) null comment '订单驳回原因',
  pay_time datetime null comment '支付时间',
  confirm_time datetime null comment '确认时间',
  complete_time datetime null comment '完成时间',
  delete_status varchar(50) not null default 'NO' comment '是否删除 [YES.是 NO.否]',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='订单表';

drop table if exists `pms_order_picture`;
create table `pms_order_picture`
(
  id int(11) auto_increment not null comment 'Id',
  order_id int(11) not null comment '订单id',
  order_no varchar(255) not null comment '订单号',
  patient_self_image varchar(255) not null comment '患者自述相关图片',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='订单图片表';

drop table if exists `pms_order_appraise`;
create table `pms_order_appraise`
(
  id int(11) auto_increment not null comment 'Id',
  order_id int(11) not null comment '订单id',
  order_no varchar(255) not null comment '订单号',
  order_score decimal(12, 2) not null comment '订单评分',
  order_evaluation varchar(255) null comment '订单评价',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='订单评价表';

drop table if exists `pms_online_inquiry_order_record`;
create table `pms_online_inquiry_order_record`
(
  id int(11) auto_increment not null comment 'Id',
  order_id int(11) not null comment '订单id',
  order_no varchar(255) not null comment '订单号',
  inquiry_time varchar(255) not null comment '在线问诊开始时间',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='在线问诊订单记录信息表';

drop table if exists `pms_prescription_order_record`;
create table `pms_prescription_order_record`
(
  id int(11) auto_increment not null comment 'Id',
  order_id int(11) not null comment '订单id',
  order_no varchar(255) not null comment '订单号',
  prescription_introduce varchar(255) not null comment '处方说明',
  prescription_image varchar(255) not null comment '处方图片',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='续方开药订单记录信息表';

drop table if exists `pms_phone_order_record`;
create table `pms_phone_order_record`
(
  id int(11) auto_increment not null comment 'Id',
  order_id int(11) not null comment '订单id',
  order_no varchar(255) not null comment '订单号',
  phone_contact_time varchar(255) not null comment '电话咨询开始时间',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='电话咨询订单记录信息表';

drop table if exists `pms_order_pay`;
create table `pms_order_pay`
(
  id int(11) auto_increment not null comment 'Id',
  order_id int(11) not null comment '订单id',
  order_no varchar(255) not null comment '订单号',
  pay_no varchar(255) not null comment '支付流水号',
  pay_state varchar(50) not null default 'TO_PAY' comment '支付状态 [TO_PAY.未支付 PAYED.已支付]',
  pay_path varchar(50) not null default 'WX_PAY' comment '支付方式类型 [WX_PAY.微信 ALI_PAY.支付宝]',
  pay_money decimal(12, 2) not null comment '支付金额',
  pay_time datetime null comment '支付时间',
  complete_time datetime null comment '完成时间',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='订单支付表';

drop table if exists `pms_order_refund`;
create table `pms_order_refund`
(
  id int(11) auto_increment not null comment 'Id',
  order_id int(11) not null comment '订单id',
  order_no varchar(255) not null comment '订单号',
  order_pay_id int(11) not null comment '订单支付id',
  refund_no varchar(255) not null comment '退款流水号',
  refund_state varchar(50) not null default 'REFUNDING' comment '退款状态 [REFUNDING.退款中 REFUNDED.已退款]',
  refund_money decimal(12, 2) not null comment '退款金额',
  refund_time datetime null comment '退款时间',
  complete_time datetime null comment '完成时间',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='订单退款表';

drop table if exists `sys_message`;
create table `sys_message`
(
  id int(11) auto_increment not null comment 'Id',
  user_id varchar(128) not null comment '用户Id',
  msg_type varchar(50) not null default 'NOTIFICATION' comment '消息类型 [NOTIFICATION.通知 WARNING.告警]',
  module varchar(255) not null comment '所属模块',
  content text null comment '操作内容',
  relate_id int(11) null comment '相关Id',
  state varchar(50) not null default 'NO' comment '状态 [YES.是 NO.否]',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='通知告警表';

drop table if exists `sys_setting`;
create table `sys_setting`
(
  id int(11) auto_increment not null comment 'Id',
  name varchar(128) not null comment '名称',
  code varchar(128) not null comment '代码',
  value text not null comment '值',
  remark varchar(255) null comment '说明',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '更新时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='配置表';

drop table if exists `sys_operation_log`;
create table `sys_operation_log`
(
  id int(11) auto_increment not null comment 'Id',
  log_type varchar(128) not null comment '日志类型',
  module varchar(255) not null comment '所属模块',
  operation_type varchar(128) not null comment '操作类型',
  content text null comment '操作内容',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP comment '创建时间',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='操作日志表';

drop table if exists `sys_role`;
create table `sys_role`
(
  id int(11) auto_increment not null comment 'Id',
  name varchar(255) not null comment '名称',
  remark varchar(255) null comment '备注',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP,
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='角色表';

drop table if exists `sys_user`;
create table `sys_user`
(
  id int(11) auto_increment not null comment 'Id',
  username varchar(255) not null comment '用户名',
  open_id varchar(255) null comment '微信open_id',
  user_type varchar(50) not null default 'ADMIN' comment '用户类型 [PATIENT.患者 DOCTOR.医生 ADMIN.平台]',
  register_source varchar(50) not null default 'PLATFORM' comment '注册来源 [WX.微信 PLATFORM.平台]',
  obj_id int(11) null comment '关联对象(doctor_info、user_info)',
  delete_status varchar(50) not null default 'NO' comment '是否删除 [YES.是 NO.否]',
  password varchar(255) null comment '密码',
  real_name varchar(255) null comment '姓名',
  phone varchar(32) null comment '手机号',
  avatar varchar(255) null comment '头像',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP,
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='用户表';

drop table if exists `sys_user_role`;
create table `sys_user_role`
(
  id int(11) auto_increment not null comment 'Id',
  user_id int(11) not null comment '用户Id',
  role_id int(11) not null comment '角色Id',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='用户角色关系表';

drop table if exists `sys_authority`;
create table `sys_authority`
(
  id int(11) auto_increment not null comment 'Id',
  authority_id int(11) not null default 0 comment '父级Id',
  type varchar(50) not null default 'MENU' comment '权限类型 [DIR.目录 MENU.菜单 BUTTON.按钮]',
  name varchar(255) not null comment '名称',
  path varchar(255) null comment '路径',
  redirect varchar(255) null comment '重定向路径',
  frame_src varchar(255) null comment '内嵌Url',
  keep_alive boolean not null default true comment '是否缓存',
  hidden boolean not null default false comment '是否隐藏',
  component varchar(255) null comment '页面组件',
  title varchar(255) not null comment '标题',
  icon varchar(255) null comment '图标',
  sort_order int(11) not null default 0 comment '序号',
  editor_id int(11) not null default 1 comment '操作人Id',
  editor_name varchar(255) not null default 'admin' comment '操作人',
  create_time datetime not null default CURRENT_TIMESTAMP,
  update_time datetime not null default CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='权限表';

drop table if exists `sys_role_authority`;
create table `sys_role_authority`
(
  id int(11) auto_increment not null comment 'Id',
  role_id int(11) not null comment 'sys_role.id',
  authority_id int(11) not null comment 'sys_authority.id',
  primary key (`id`)
) engine=InnoDB default charset=utf8mb4 collate=utf8mb4_general_ci comment='角色权限对应表';



create unique index ix_id_no on `pms_doctor_info` (id_no);
create unique index ix_phone_number on `pms_doctor_info` (phone_number);


create index ix_phone_number on `pms_doctor_family_address_info` (phone_number);


create unique index ix_id_no on `pms_user_info` (id_no);
create unique index ix_phone_number on `pms_user_info` (phone_number);


create index ix_patient_id_no on `pms_medical_report` (patient_id_no);


create index ix_coupon_type on `pms_coupon_info` (coupon_type);


create index ix_coupon_id on `pms_user_coupon_info` (coupon_id);
create index ix_coupon_type on `pms_user_coupon_info` (coupon_type);


create index ix_user_info_id on `pms_user_attention_info` (user_info_id);
create index ix_doctor_id on `pms_user_attention_info` (doctor_id);


create index ix_patient_id on `pms_patient_prescription_info` (patient_id);


create index ix_user_info_id on `pms_family_doctor` (user_info_id);


create unique index ix_order_no on `pms_order` (order_no);
create index ix_order_state on `pms_order` (order_state);
create index ix_order_type on `pms_order` (order_type);


create index ix_order_no on `pms_order_picture` (order_no);


create index ix_order_no on `pms_order_appraise` (order_no);


create index ix_order_no on `pms_online_inquiry_order_record` (order_no);


create index ix_order_no on `pms_prescription_order_record` (order_no);


create index ix_order_no on `pms_phone_order_record` (order_no);


create unique index ix_order_no on `pms_order_pay` (order_no);
create unique index ix_pay_no on `pms_order_pay` (pay_no);


create unique index ix_order_no on `pms_order_refund` (order_no);
create unique index ix_refund_no on `pms_order_refund` (refund_no);


create index ix_msg_type on `sys_message` (msg_type);
create index ix_editor_id_create_time on `sys_message` (editor_id,create_time);


create unique index ix_code on `sys_setting` (code);


create index ix_create_time on `sys_operation_log` (create_time);


create unique index ix_name on `sys_role` (name);


create unique index ix_username on `sys_user` (username);
create unique index ix_phone on `sys_user` (phone);


create unique index ix_name on `sys_authority` (name);
create index ix_authority_id on `sys_authority` (authority_id);


create index ix_role_id on `sys_role_authority` (role_id);
create index ix_authority_id on `sys_role_authority` (authority_id);

