/**
 * 项目：互联网医疗
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.base;

import java.io.Serial;
import java.io.Serializable;

import lombok.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(value = {"handler"}, ignoreUnknown = true)
public abstract class BaseDomain implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * Id
     * @return
     */
    public abstract Serializable getId();

    /**
     * 设置默认值
     */
    public BaseDomain setDefault() {
        return this;
    }

    /**
     * 数据验证
     */
    public boolean validate(boolean throwException) {
        return true;
    }

    /**
     * 数据验证
     */
    public boolean validate() {
        return this.validate(false);
    }
}
