/**
 * 项目：互联网医疗
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.config;

import cn.dev33.satoken.exception.NotLoginException;
import com.xwd.hospital.server.rest.res.ApiResponse;
import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Slf4j
@Configuration
@ControllerAdvice
public class ExceptionHandler {
    private static final String ENV_DEV = "dev";

    @Value("${spring.profiles.active}")
    private String profile;

    @ResponseBody
    @ResponseStatus(HttpStatus.OK)
    @org.springframework.web.bind.annotation.ExceptionHandler(NotLoginException.class)
    public ApiResponse<?> handleSaTokenException(NotLoginException e) {
        log.error("sa-token error", e);
        ApiResponse<?> resp = ApiResponse.fail(e.getCode(), e.getMessage());
        if (profile.contains(ENV_DEV)) {
            resp.setDetailMessage(e.getMessage());
        }
        return resp;
    }

    @ResponseBody
    @ResponseStatus(HttpStatus.OK)
    @org.springframework.web.bind.annotation.ExceptionHandler(ApiCode.ApiException.class)
    public ApiResponse handleBzException(ApiCode.ApiException e) {
        log.error("business error", e);
        ApiResponse resp = ApiResponse.fail(e.getCode(), e.getMessage());
        if (profile.contains(ENV_DEV)) {
            resp.setDetailMessage(e.getMessage());
        }
        return resp;
    }

    @ResponseBody
    @ResponseStatus(HttpStatus.OK)
    @org.springframework.web.bind.annotation.ExceptionHandler(Throwable.class)
    public ApiResponse handleException(Throwable e) {
        log.error("server error", e);
        ApiResponse resp = ApiResponse.fail(ApiCode.SERVER_ERROR);
        if (profile.contains(ENV_DEV)) {
            resp.setDetailMessage(e.getMessage());
        }
        return resp;
    }
}
