/**
 * 项目：互联网医疗
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.config;

import cn.dev33.satoken.interceptor.SaInterceptor;
import cn.dev33.satoken.jwt.StpLogicJwtForStateless;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author hncboy
 * @date 2023-3-28
 * SaToken 配置，目前针对管理端鉴权
 */
@Configuration
public class SaTokenConfig implements WebMvcConfigurer {

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        // 注册 Sa-Token 拦截器，校验规则为 StpUtil.checkLogin() 登录校验。
        registry.addInterceptor(new SaInterceptor(handle -> {
                    SaRouter.match("/**").check(r -> StpUtil.checkLogin());
                }))
                // websocket
                .excludePathPatterns("/ws")
                .excludePathPatterns("/websocket")
                // 错误页面
                .excludePathPatterns("/error")
                // 放行用户登录注册相关接口
                .excludePathPatterns("/v1/system/user/login")
                .excludePathPatterns("/v1/system/user/register")
                .excludePathPatterns("/v1/system/user/miniAppLogin")
                .excludePathPatterns("/v1/system/user/miniAppRegister")
                .excludePathPatterns("/v1/system/user/wxUpdate")
                .excludePathPatterns("/v1/system/user/getPhoneNumber")
                .excludePathPatterns("/v1/system/sms/sendSms")
                .excludePathPatterns("/v1/system/home/patientMiniAppHome")
                .excludePathPatterns("/v1/system/payment/payNotify")
                .excludePathPatterns("/v1/system/payment/refundNotify")
                .excludePathPatterns("/v1/system/sms/callback")
                // swagger 放行
                .excludePathPatterns("/webjars/**")
                .excludePathPatterns("/doc.html")
                .excludePathPatterns("/docs/**")
                .excludePathPatterns("/v3/api-docs/**");
    }

    @Bean
    public StpLogic getStpLogicJwt() {
        return new StpLogicJwtForStateless();
    }
}
