/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：科室信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.enums.DepartmentLevelEnum;
import com.xwd.hospital.server.enums.YesNoEnum;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`pms_department_info`")
@Schema(name = "DepartmentInfo", description = "科室信息表")
public class DepartmentInfo extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 科室名称
     */
    @TableField(value = "department_name")
    @Schema(description = "科室名称", nullable = false)
    private String departmentName;
    /**
     * 科室介绍
     */
    @TableField(value = "department_introduce", select = false)
    @Schema(description = "科室介绍", nullable = false)
    private String departmentIntroduce;
    /**
     * 科室层级
     */
    @TableField(value = "department_level")
    @Schema(description = "科室层级", nullable = false)
    private DepartmentLevelEnum departmentLevel;
    /**
     * 上级科室id
     */
    @TableField(value = "parent_id")
    @Schema(description = "上级科室id")
    private Long parentId;
    /**
     * 是否隐藏
     */
    @TableField(value = "hidden_status")
    @Schema(description = "是否隐藏", nullable = false)
    private YesNoEnum hiddenStatus;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "创建时间", nullable = false)
    private java.util.Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "更新时间", nullable = false)
    private java.util.Date updateTime;

    /**
     * 设置默认值
     */
    @Override
    public DepartmentInfo setDefault() {
        if (this.getDepartmentLevel() == null) {
            this.setDepartmentLevel(DepartmentLevelEnum.FIRST_LEVEL);
        }
        if (this.getHiddenStatus() == null) {
            this.setHiddenStatus(YesNoEnum.NO);
        }
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getDepartmentName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "科室名称不能为空！");
            }
            return false;
        }
        if (this.getDepartmentIntroduce() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "科室介绍不能为空！");
            }
            return false;
        }
        if (this.getDepartmentLevel() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "科室层级不能为空！");
            }
            return false;
        }
        if (this.getHiddenStatus() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "是否隐藏不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
