/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：医生服务信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.enums.DoctorServiceEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.DoctorInfo;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`pms_doctor_service_info`")
@Schema(name = "DoctorServiceInfo", description = "医生服务信息表")
public class DoctorServiceInfo extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 医生Id
     */
    @TableField(value = "doctor_id")
    @Schema(description = "医生Id", nullable = false)
    private Long doctorId;
    /**
     * 医生Id
     */
    @Schema(description = "医生Id")
    @TableField(exist = false)
    private DoctorInfo doctor;
    /**
     * 服务名称
     */
    @TableField(value = "service_name")
    @Schema(description = "服务名称", nullable = false)
    private DoctorServiceEnum serviceName;
    /**
     * 服务价格
     */
    @TableField(value = "service_price")
    @Schema(description = "服务价格", nullable = false)
    private java.math.BigDecimal servicePrice;
    /**
     * 服务状态
     */
    @TableField(value = "service_state")
    @Schema(description = "服务状态", nullable = false)
    private YesNoEnum serviceState;
    /**
     * 每日服务开始时间
     */
    @TableField(value = "service_start_time")
    @Schema(description = "每日服务开始时间", nullable = false)
    private String serviceStartTime;
    /**
     * 每日服务结束时间
     */
    @TableField(value = "service_end_time")
    @Schema(description = "每日服务结束时间", nullable = false)
    private String serviceEndTime;
    /**
     * 服务手机
     */
    @TableField(value = "service_phone_number")
    @Schema(description = "服务手机")
    private String servicePhoneNumber;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "创建时间", nullable = false)
    private java.util.Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "更新时间", nullable = false)
    private java.util.Date updateTime;

    /**
     * 设置默认值
     */
    @Override
    public DoctorServiceInfo setDefault() {
        if (this.getServiceName() == null) {
            this.setServiceName(DoctorServiceEnum.ONLINE_INQUIRY);
        }
        if (this.getServiceState() == null) {
            this.setServiceState(YesNoEnum.NO);
        }
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getDoctorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "医生Id不能为空！");
            }
            return false;
        }
        if (this.getServiceName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "服务名称不能为空！");
            }
            return false;
        }
        if (this.getServicePrice() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "服务价格不能为空！");
            }
            return false;
        }
        if (this.getServiceState() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "服务状态不能为空！");
            }
            return false;
        }
        if (this.getServiceStartTime() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "每日服务开始时间不能为空！");
            }
            return false;
        }
        if (this.getServiceEndTime() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "每日服务结束时间不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
