/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：邀请信息记录表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.domain.User;
import com.xwd.hospital.server.domain.User;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`pms_invite_register_record`")
@Schema(name = "InviteRegisterRecord", description = "邀请信息记录表")
public class InviteRegisterRecord extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 邀请人Id
     */
    @TableField(value = "invite_user_id")
    @Schema(description = "邀请人Id", nullable = false)
    private Long inviteUserId;
    /**
     * 邀请人Id
     */
    @Schema(description = "邀请人Id")
    @TableField(exist = false)
    private User inviteUser;
    /**
     * 被邀请人Id
     */
    @TableField(value = "invited_user_id")
    @Schema(description = "被邀请人Id", nullable = false)
    private Long invitedUserId;
    /**
     * 被邀请人Id
     */
    @Schema(description = "被邀请人Id")
    @TableField(exist = false)
    private User invitedUser;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "创建时间", nullable = false)
    private java.util.Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "更新时间", nullable = false)
    private java.util.Date updateTime;

    /**
     * 设置默认值
     */
    @Override
    public InviteRegisterRecord setDefault() {
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getInviteUserId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "邀请人Id不能为空！");
            }
            return false;
        }
        if (this.getInvitedUserId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "被邀请人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
