/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：操作日志表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`sys_operation_log`")
@Schema(name = "OperationLog", description = "操作日志表")
public class OperationLog extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 日志类型
     */
    @TableField(value = "log_type")
    @Schema(description = "日志类型", nullable = false)
    private String logType;
    /**
     * 所属模块
     */
    @TableField(value = "module")
    @Schema(description = "所属模块", nullable = false)
    private String module;
    /**
     * 操作类型
     */
    @TableField(value = "operation_type")
    @Schema(description = "操作类型", nullable = false)
    private String operationType;
    /**
     * 操作内容
     */
    @TableField(value = "content", select = false)
    @Schema(description = "操作内容")
    private String content;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "创建时间", nullable = false)
    private java.util.Date createTime;

    /**
     * 设置默认值
     */
    @Override
    public OperationLog setDefault() {
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getLogType() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "日志类型不能为空！");
            }
            return false;
        }
        if (this.getModule() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "所属模块不能为空！");
            }
            return false;
        }
        if (this.getOperationType() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作类型不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
