/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：订单表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.enums.OrderStateEnum;
import com.xwd.hospital.server.enums.OrderTypeEnum;
import com.xwd.hospital.server.enums.SexTypeEnum;
import com.xwd.hospital.server.enums.YesNoEnum;
import com.xwd.hospital.server.domain.UserInfo;
import com.xwd.hospital.server.domain.DoctorInfo;
import com.xwd.hospital.server.domain.PatientInfo;
import com.xwd.hospital.server.domain.UserCouponInfo;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`pms_order`")
@Schema(name = "Order", description = "订单表")
public class Order extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 用户Id
     */
    @TableField(value = "user_info_id")
    @Schema(description = "用户Id", nullable = false)
    private Long userInfoId;
    /**
     * 用户Id
     */
    @Schema(description = "用户Id")
    @TableField(exist = false)
    private UserInfo userInfo;
    /**
     * 医生Id
     */
    @TableField(value = "doctor_id")
    @Schema(description = "医生Id", nullable = false)
    private Long doctorId;
    /**
     * 医生Id
     */
    @Schema(description = "医生Id")
    @TableField(exist = false)
    private DoctorInfo doctor;
    /**
     * 就诊人Id
     */
    @TableField(value = "patient_id")
    @Schema(description = "就诊人Id", nullable = false)
    private Long patientId;
    /**
     * 就诊人Id
     */
    @Schema(description = "就诊人Id")
    @TableField(exist = false)
    private PatientInfo patient;
    /**
     * 订单号
     */
    @TableField(value = "order_no")
    @Schema(description = "订单号", nullable = false)
    private String orderNo;
    /**
     * 订单状态
     */
    @TableField(value = "order_state")
    @Schema(description = "订单状态", nullable = false)
    private OrderStateEnum orderState;
    /**
     * 订单类型
     */
    @TableField(value = "order_type")
    @Schema(description = "订单类型", nullable = false)
    private OrderTypeEnum orderType;
    /**
     * 订单金额
     */
    @TableField(value = "order_price")
    @Schema(description = "订单金额", nullable = false)
    private java.math.BigDecimal orderPrice;
    /**
     * 订单优惠金额
     */
    @TableField(value = "order_discount")
    @Schema(description = "订单优惠金额", nullable = false)
    private java.math.BigDecimal orderDiscount;
    /**
     * 订单实际支付金额
     */
    @TableField(value = "order_actual_pay")
    @Schema(description = "订单实际支付金额", nullable = false)
    private java.math.BigDecimal orderActualPay;
    /**
     * 优惠券Id
     */
    @TableField(value = "user_coupon_id")
    @Schema(description = "优惠券Id")
    private Long userCouponId;
    /**
     * 优惠券Id
     */
    @Schema(description = "优惠券Id")
    @TableField(exist = false)
    private UserCouponInfo userCoupon;
    /**
     * 预约日期
     */
    @TableField(value = "appointment_date")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "预约日期")
    private java.util.Date appointmentDate;
    /**
     * 每日服务开始时间
     */
    @TableField(value = "service_start_time")
    @Schema(description = "每日服务开始时间", nullable = false)
    private String serviceStartTime;
    /**
     * 每日服务结束时间
     */
    @TableField(value = "service_end_time")
    @Schema(description = "每日服务结束时间", nullable = false)
    private String serviceEndTime;
    /**
     * 医院名称
     */
    @TableField(value = "hospital_name")
    @Schema(description = "医院名称", nullable = false)
    private String hospitalName;
    /**
     * 科室名称
     */
    @TableField(value = "department_name")
    @Schema(description = "科室名称", nullable = false)
    private String departmentName;
    /**
     * 医生姓名
     */
    @TableField(value = "doctor_name")
    @Schema(description = "医生姓名", nullable = false)
    private String doctorName;
    /**
     * 就诊人姓名
     */
    @TableField(value = "patient_name")
    @Schema(description = "就诊人姓名", nullable = false)
    private String patientName;
    /**
     * 性别
     */
    @TableField(value = "patient_sex")
    @Schema(description = "性别", nullable = false)
    private SexTypeEnum patientSex;
    /**
     * 身份证号码
     */
    @TableField(value = "patient_id_no")
    @Schema(description = "身份证号码")
    private String patientIdNo;
    /**
     * 就诊人手机号码
     */
    @TableField(value = "patient_phone_number")
    @Schema(description = "就诊人手机号码")
    private String patientPhoneNumber;
    /**
     * 就诊人出生日期
     */
    @TableField(value = "patient_born_date")
    @Schema(description = "就诊人出生日期", nullable = false)
    private String patientBornDate;
    /**
     * 患者自述
     */
    @TableField(value = "patient_self_introduce", select = false)
    @Schema(description = "患者自述", nullable = false)
    private String patientSelfIntroduce;
    /**
     * 订单驳回原因
     */
    @TableField(value = "cancel_reason")
    @Schema(description = "订单驳回原因")
    private String cancelReason;
    /**
     * 支付时间
     */
    @TableField(value = "pay_time")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "支付时间")
    private java.util.Date payTime;
    /**
     * 确认时间
     */
    @TableField(value = "confirm_time")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "确认时间")
    private java.util.Date confirmTime;
    /**
     * 完成时间
     */
    @TableField(value = "complete_time")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "完成时间")
    private java.util.Date completeTime;
    /**
     * 是否删除
     */
    @TableField(value = "delete_status")
    @Schema(description = "是否删除", nullable = false)
    private YesNoEnum deleteStatus;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "创建时间", nullable = false)
    private java.util.Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "更新时间", nullable = false)
    private java.util.Date updateTime;

    /**
     * 患者自述图片链接
     */
    @TableField(exist = false)
    private List<String> pictureList;

    /**
     * 患者所提交的处方
     */
    @TableField(exist = false)
    private PatientPrescriptionInfo patientPrescriptionInfo;

    @TableField(exist = false)
    private PrescriptionOrderRecord prescriptionOrderRecord;

    /**
     * 设置默认值
     */
    @Override
    public Order setDefault() {
        if (this.getOrderState() == null) {
            this.setOrderState(OrderStateEnum.TO_PAY);
        }
        if (this.getOrderType() == null) {
            this.setOrderType(OrderTypeEnum.ONLINE_INQUIRY);
        }
        if (this.getOrderDiscount() == null) {
            this.setOrderDiscount(java.math.BigDecimal.valueOf(0));
        }
        if (this.getPatientSex() == null) {
            this.setPatientSex(SexTypeEnum.MALE);
        }
        if (this.getDeleteStatus() == null) {
            this.setDeleteStatus(YesNoEnum.NO);
        }
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getUserInfoId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "用户Id不能为空！");
            }
            return false;
        }
        if (this.getDoctorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "医生Id不能为空！");
            }
            return false;
        }
        if (this.getPatientId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "就诊人Id不能为空！");
            }
            return false;
        }
        if (this.getOrderNo() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "订单号不能为空！");
            }
            return false;
        }
        if (this.getOrderState() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "订单状态不能为空！");
            }
            return false;
        }
        if (this.getOrderType() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "订单类型不能为空！");
            }
            return false;
        }
        if (this.getOrderPrice() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "订单金额不能为空！");
            }
            return false;
        }
        if (this.getOrderDiscount() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "订单优惠金额不能为空！");
            }
            return false;
        }
        if (this.getOrderActualPay() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "订单实际支付金额不能为空！");
            }
            return false;
        }
        if (this.getServiceStartTime() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "每日服务开始时间不能为空！");
            }
            return false;
        }
        if (this.getServiceEndTime() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "每日服务结束时间不能为空！");
            }
            return false;
        }
        if (this.getHospitalName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "医院名称不能为空！");
            }
            return false;
        }
        if (this.getDepartmentName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "科室名称不能为空！");
            }
            return false;
        }
        if (this.getDoctorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "医生姓名不能为空！");
            }
            return false;
        }
        if (this.getPatientName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "就诊人姓名不能为空！");
            }
            return false;
        }
        if (this.getPatientSex() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "性别不能为空！");
            }
            return false;
        }
        if (this.getPatientBornDate() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "就诊人出生日期不能为空！");
            }
            return false;
        }
        if (this.getPatientSelfIntroduce() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "患者自述不能为空！");
            }
            return false;
        }
        if (this.getDeleteStatus() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "是否删除不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
