/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：用户表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;
import com.xwd.hospital.server.enums.UserTypeEnum;
import com.xwd.hospital.server.enums.RegisterSourceEnum;
import com.xwd.hospital.server.enums.YesNoEnum;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`sys_user`")
@Schema(name = "User", description = "用户表")
public class User extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * Id
     */
    @Schema(description = "Id")
    @TableField(exist = false)
    private List<Role> roleList;
    /**
     * 用户名
     */
    @TableField(value = "username")
    @Schema(description = "用户名", nullable = false)
    private String username;
    /**
     * 腾讯云im中的uerId
     */
    @TableField(value = "im_user_id")
    @Schema(description = "腾讯云im中的uerId")
    private String imUserId;
    /**
     * 微信open_id
     */
    @TableField(value = "open_id")
    @Schema(description = "微信open_id")
    private String openId;
    /**
     * 用户类型
     */
    @TableField(value = "user_type")
    @Schema(description = "用户类型", nullable = false)
    private UserTypeEnum userType;
    /**
     * 注册来源
     */
    @TableField(value = "register_source")
    @Schema(description = "注册来源", nullable = false)
    private RegisterSourceEnum registerSource;
    /**
     * 关联对象(doctor_info、user_info)
     */
    @TableField(value = "obj_id")
    @Schema(description = "关联对象(doctor_info、user_info)")
    private Long objId;
    /**
     * 是否删除
     */
    @TableField(value = "delete_status")
    @Schema(description = "是否删除", nullable = false)
    private YesNoEnum deleteStatus;
    /**
     * 密码
     */
    @TableField(value = "password")
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @Schema(description = "密码")
    private String password;
    /**
     * 姓名
     */
    @TableField(value = "real_name")
    @Schema(description = "姓名")
    private String realName;
    /**
     * 手机号
     */
    @TableField(value = "phone")
    @Schema(description = "手机号")
    private String phone;
    /**
     * 头像
     */
    @TableField(value = "avatar")
    @Schema(description = "头像")
    private String avatar;
    /**
     * 操作人Id
     */
    @TableField(value = "editor_id")
    @Schema(description = "操作人Id", nullable = false)
    private Long editorId;
    /**
     * 操作人
     */
    @TableField(value = "editor_name")
    @Schema(description = "操作人", nullable = false)
    private String editorName;
    /**
     * 
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "", nullable = false)
    private java.util.Date createTime;
    /**
     * 
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "", nullable = false)
    private java.util.Date updateTime;

    /**
     * 设置默认值
     */
    @Override
    public User setDefault() {
        if (this.getUserType() == null) {
            this.setUserType(UserTypeEnum.ADMIN);
        }
        if (this.getRegisterSource() == null) {
            this.setRegisterSource(RegisterSourceEnum.PLATFORM);
        }
        if (this.getDeleteStatus() == null) {
            this.setDeleteStatus(YesNoEnum.NO);
        }
        if (this.getEditorId() == null) {
            this.setEditorId(1L);
        }
        if (this.getEditorName() == null) {
            this.setEditorName("admin");
        }
        if (this.getCreateTime() == null) {
            this.setCreateTime(new java.util.Date());
        }
        if (this.getUpdateTime() == null) {
            this.setUpdateTime(new java.util.Date());
        }
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getUsername() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "用户名不能为空！");
            }
            return false;
        }
        int usernameMaxLength = Integer.valueOf("20");
        if (this.getUsername().length() >= usernameMaxLength) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "用户名长度不能大于20！");
            }
            return false;
        }
        int openIdMaxLength = Integer.valueOf("50");
        if (this.getOpenId().length() >= openIdMaxLength) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "微信open_id长度不能大于50！");
            }
            return false;
        }
        if (this.getUserType() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "用户类型不能为空！");
            }
            return false;
        }
        if (this.getRegisterSource() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "注册来源不能为空！");
            }
            return false;
        }
        Long objIdMax = Long.valueOf("50");
        if (this.getObjId() >= objIdMax) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "关联对象(doctor_info、user_info)不能大于或等于50！");
            }
            return false;
        }
        if (this.getDeleteStatus() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "是否删除不能为空！");
            }
            return false;
        }
        if (this.getEditorId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人Id不能为空！");
            }
            return false;
        }
        if (this.getEditorName() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "操作人不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
