/**
 * 项目：互联网医疗
 * 模型分组：系统管理
 * 模型名称：用户角色关系表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.domain;

import java.io.Serializable;

import com.xwd.hospital.server.rest.res.ApiCode;
import lombok.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.format.annotation.DateTimeFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.xwd.hospital.server.base.BaseDomain;

@Data
@Builder(builderMethodName = "newBuilder")
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("`sys_user_role`")
@Schema(name = "UserRole", description = "用户角色关系表")
public class UserRole extends BaseDomain {
    /**
     * Id
     */
    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "Id", nullable = false)
    private Long id;
    /**
     * 用户Id
     */
    @TableField(value = "user_id")
    @Schema(description = "用户Id", nullable = false)
    private Long userId;
    /**
     * 角色Id
     */
    @TableField(value = "role_id")
    @Schema(description = "角色Id", nullable = false)
    private Long roleId;

    /**
     * 设置默认值
     */
    @Override
    public UserRole setDefault() {
        return this;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate(boolean throwException) {
        if (this.getUserId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "用户Id不能为空！");
            }
            return false;
        }
        if (this.getRoleId() == null) {
            if (throwException) {
                throw new ApiCode.ApiException(-1, "角色Id不能为空！");
            }
            return false;
        }
        return true;
    }

    /**
     * 数据验证
     */
    @Override
    public boolean validate() {
        return this.validate(false);
    }

}
