package com.xwd.hospital.server.dto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.xwd.hospital.server.domain.DepartmentInfo;
import com.xwd.hospital.server.domain.DoctorInfo;
import com.xwd.hospital.server.domain.HospitalInfo;
import com.xwd.hospital.server.enums.AuditStateEnum;
import com.xwd.hospital.server.enums.DoctorTitleEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

@Data
public class MedicalQualificationDto {
    /**
     * 医生Id
     */
    @TableField(value = "doctor_id")
    @Schema(description = "医生Id", nullable = false)
    private Long doctorId;

    /**
     * 医院Id
     */
    @TableField(value = "hospital_id")
    @Schema(description = "医院Id", nullable = false)
    private Long hospitalId;
    /**
     * 科室Id
     */
    @TableField(value = "department_id")
    @Schema(description = "科室Id", nullable = false)
    private Long departmentId;
    /**
     * 职称
     */
    @TableField(value = "title")
    @Schema(description = "职称", nullable = false)
    private DoctorTitleEnum title;

    private List<String> pictureList;

}
