package com.xwd.hospital.server.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.xwd.hospital.server.enums.OrderStateEnum;
import com.xwd.hospital.server.enums.OrderTypeEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class OrderDto {
    private Long orderId;
    private String orderNo;
    private String hospitalName;
    private String doctorName;
    private String departmentName;
    private String patientName;
    private String patientSex;
    private OrderStateEnum orderState;
    private BigDecimal actualPrice;
    private OrderTypeEnum orderType;
    private Date createTime;
    /**
     * 预约日期
     */
    private java.util.Date appointmentDate;
    /**
     * 每日服务开始时间
     */
    private String serviceStartTime;
    /**
     * 每日服务结束时间
     */

    private String serviceEndTime;
    private String imUserId;

}
