package com.xwd.hospital.server.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.xwd.hospital.server.enums.SexTypeEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.List;

@Data
public class ReportDto {
    /**
     * 患者姓名
     */
    @TableField(value = "patient_name")
    @Schema(description = "患者姓名", nullable = false)
    private String patientName;
    /**
     * 患者身份证号码
     */
    @TableField(value = "patient_id_no")
    @Schema(description = "患者身份证号码", nullable = false)
    private String patientIdNo;
    /**
     * 性别
     */
    @TableField(value = "sex")
    @Schema(description = "性别", nullable = false)
    private SexTypeEnum sex;
    /**
     * 患者年龄
     */
    @TableField(value = "age")
    @Schema(description = "患者年龄", nullable = false)
    private Integer age;
    /**
     * 影像报告项目
     */
    @TableField(value = "report_item", select = false)
    @Schema(description = "影像报告项目", nullable = false)
    private String reportItem;
    /**
     * 影像说明
     */
    @TableField(value = "report_declare", select = false)
    @Schema(description = "影像说明", nullable = false)
    private String reportDeclare;
    /**
     * 报告医院
     */
    @TableField(value = "report_hospital")
    @Schema(description = "报告医院", nullable = false)
    private String reportHospital;
    /**
     * 报告医生
     */
    @TableField(value = "report_doctor")
    @Schema(description = "报告医生", nullable = false)
    private String reportDoctor;

    /**
     * 报告时间
     */
    @TableField(value = "report_time")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Schema(description = "报告时间", nullable = false)
    private java.util.Date reportTime;

    private String phoneNumber;

    private List<String> pictureList;

}
