/**
 * 项目：互联网医疗
 * 模型分组：服务管理
 * 模型名称：医生信息表
 * @Author: xiongwei
 * @Date: 2023-09-05 09:42:00
 */

package com.xwd.hospital.server.repository;

import java.io.Serializable;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.xwd.hospital.server.dto.DiseaseDto;
import com.xwd.hospital.server.dto.DoctorDto;
import com.xwd.hospital.server.dto.DoctorInfoDto;
import org.springframework.stereotype.Repository;
import org.apache.ibatis.annotations.Param;
import com.xwd.hospital.server.domain.DoctorInfo;
import com.xwd.hospital.server.repository.base.DoctorInfoBaseMapper;

@Repository
public interface DoctorInfoMapper extends DoctorInfoBaseMapper {

    List<DoctorDto> queryDoctorList(@Param("sickness")String sickness,
                                    @Param("doctorName")String doctorName,
                                    @Param("departmentName")String departmentName,
                                    @Param("departmentIdList") List<Long> departmentIdList);

    DoctorInfoDto queryDoctorDetail(@Param("doctorId")Long doctorId);

    String selectNameById(Long doctorId);

    List<DiseaseDto> queryDiseaseList(@Param("doctorId")Long doctorId);
}
